/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.utils;

import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.capability.MobEnchantCapability;
import com.baguchan.enchantwithmob.capability.MobEnchantHandler;
import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.registry.MobEnchants;
import com.baguchan.enchantwithmob.registry.ModItems;
import com.baguchan.enchantwithmob.utils.MobEnchantmentData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MobEnchantUtils {
    public static final String TAG_MOBENCHANT = "MobEnchant";
    public static final String TAG_ENCHANT_LEVEL = "EnchantLevel";
    public static final String TAG_STORED_MOBENCHANTS = "StoredMobEnchants";

    public static void executeIfPresent(LivingEntity entity, MobEnchant mobEnchantment, Runnable runnable) {
        if (entity != null) {
            entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                if (MobEnchantUtils.findMobEnchantFromHandler(cap.getMobEnchants(), mobEnchantment)) {
                    runnable.run();
                }
            });
        }
    }

    @Nullable
    public static MobEnchant getEnchantFromNBT(@Nullable CompoundTag tag) {
        if (tag != null && MobEnchants.getRegistry().containsKey(ResourceLocation.m_135820_((String)tag.m_128461_(TAG_MOBENCHANT)))) {
            return (MobEnchant)MobEnchants.getRegistry().getValue(ResourceLocation.m_135820_((String)tag.m_128461_(TAG_MOBENCHANT)));
        }
        return null;
    }

    public static int getEnchantLevelFromNBT(@Nullable CompoundTag tag) {
        if (tag != null) {
            return tag.m_128451_(TAG_ENCHANT_LEVEL);
        }
        return 0;
    }

    @Nullable
    public static MobEnchant getEnchantFromString(@Nullable String id) {
        if (id != null && MobEnchants.getRegistry().containsKey(ResourceLocation.m_135820_((String)id))) {
            return (MobEnchant)MobEnchants.getRegistry().getValue(ResourceLocation.m_135820_((String)id));
        }
        return null;
    }

    @Nullable
    public static MobEnchant getEnchantFromResourceLocation(@Nullable ResourceLocation id) {
        if (id != null && MobEnchants.getRegistry().containsKey(id)) {
            return (MobEnchant)MobEnchants.getRegistry().getValue(id);
        }
        return null;
    }

    public static boolean hasMobEnchant(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        return compoundnbt != null && compoundnbt.m_128441_(TAG_STORED_MOBENCHANTS);
    }

    public static ListTag getEnchantmentListForNBT(CompoundTag compoundnbt) {
        return compoundnbt != null ? compoundnbt.m_128437_(TAG_STORED_MOBENCHANTS, 10) : new ListTag();
    }

    public static Map<MobEnchant, Integer> getEnchantments(ItemStack stack) {
        ListTag listnbt = MobEnchantUtils.getEnchantmentListForNBT(stack.m_41783_());
        return MobEnchantUtils.makeMobEnchantListFromListNBT(listnbt);
    }

    public static void setEnchantments(Map<MobEnchant, Integer> enchMap, ItemStack stack) {
        ListTag listnbt = new ListTag();
        for (Map.Entry<MobEnchant, Integer> entry : enchMap.entrySet()) {
            MobEnchant enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.m_128359_(TAG_MOBENCHANT, String.valueOf(MobEnchants.getRegistry().getKey((IForgeRegistryEntry)enchantment)));
            compoundnbt.m_128376_(TAG_ENCHANT_LEVEL, (short)i);
            listnbt.add((Object)compoundnbt);
            if (stack.m_41720_() != ModItems.MOB_ENCHANT_BOOK) continue;
            MobEnchantUtils.addMobEnchantToItemStack(stack, enchantment, i);
        }
        if (listnbt.isEmpty()) {
            stack.m_41749_(TAG_STORED_MOBENCHANTS);
        }
    }

    private static Map<MobEnchant, Integer> makeMobEnchantListFromListNBT(ListTag p_226652_0_) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (int i = 0; i < p_226652_0_.size(); ++i) {
            CompoundTag compoundnbt = p_226652_0_.m_128728_(i);
            MobEnchant mobEnchant = MobEnchantUtils.getEnchantFromString(compoundnbt.m_128461_(TAG_MOBENCHANT));
            map.put(mobEnchant, compoundnbt.m_128451_(TAG_ENCHANT_LEVEL));
        }
        return map;
    }

    public static void addMobEnchantToItemStack(ItemStack itemIn, MobEnchant mobenchant, int level) {
        ListTag listnbt = MobEnchantUtils.getEnchantmentListForNBT(itemIn.m_41783_());
        boolean flag = true;
        ResourceLocation resourcelocation = MobEnchants.getRegistry().getKey((IForgeRegistryEntry)mobenchant);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            ResourceLocation resourcelocation1 = ResourceLocation.m_135820_((String)compoundnbt.m_128461_(TAG_MOBENCHANT));
            if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
            if (compoundnbt.m_128451_(TAG_ENCHANT_LEVEL) < level) {
                compoundnbt.m_128405_(TAG_ENCHANT_LEVEL, level);
            }
            flag = false;
            break;
        }
        if (flag) {
            CompoundTag compoundnbt1 = new CompoundTag();
            compoundnbt1.m_128359_(TAG_MOBENCHANT, String.valueOf(resourcelocation));
            compoundnbt1.m_128405_(TAG_ENCHANT_LEVEL, level);
            listnbt.add((Object)compoundnbt1);
        }
        itemIn.m_41783_().m_128365_(TAG_STORED_MOBENCHANTS, (Tag)listnbt);
    }

    public static boolean addItemMobEnchantToEntity(ItemStack itemIn, LivingEntity entity, MobEnchantCapability capability) {
        ListTag listnbt = MobEnchantUtils.getEnchantmentListForNBT(itemIn.m_41783_());
        boolean flag = false;
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(MobEnchantUtils.getEnchantFromNBT(compoundnbt), entity, capability)) continue;
            capability.addMobEnchant(entity, MobEnchantUtils.getEnchantFromNBT(compoundnbt), MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt));
            flag = true;
        }
        return flag;
    }

    public static void removeMobEnchantToEntity(LivingEntity entity, MobEnchantCapability capability) {
        capability.removeAllMobEnchant(entity);
    }

    public static int getExperienceFromMob(MobEnchantCapability cap) {
        int l = 0;
        for (MobEnchantHandler list : cap.getMobEnchants()) {
            MobEnchant enchantment = list.getMobEnchant();
            int integer = list.getEnchantLevel();
            l += enchantment.getMinEnchantability(integer);
        }
        return l;
    }

    public static boolean addRandomEnchantmentToEntity(LivingEntity livingEntity, MobEnchantCapability capability, Random random, int level, boolean allowRare) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowRare);
        boolean flag = false;
        for (MobEnchantmentData enchantmentdata : list) {
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(enchantmentdata.enchantment, livingEntity, capability)) continue;
            capability.addMobEnchant(livingEntity, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel);
            flag = true;
        }
        return flag;
    }

    public static boolean addUnstableRandomEnchantmentToEntity(LivingEntity livingEntity, LivingEntity ownerEntity, MobEnchantCapability capability, Random random, int level, boolean allowRare) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowRare);
        boolean flag = false;
        for (MobEnchantmentData enchantmentdata : list) {
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(enchantmentdata.enchantment, livingEntity, capability)) continue;
            capability.addMobEnchantFromOwner(livingEntity, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel, ownerEntity);
            flag = true;
        }
        if (flag) {
            capability.addOwner(livingEntity, ownerEntity);
        }
        return flag;
    }

    public static ItemStack addRandomEnchantmentToItemStack(Random random, ItemStack stack, int level, boolean allowRare) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowRare);
        for (MobEnchantmentData enchantmentdata : list) {
            MobEnchantUtils.addMobEnchantToItemStack(stack, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel);
        }
        return stack;
    }

    public static boolean findMobEnchantHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (!((Object)((Object)mobEnchant.getMobEnchant())).equals((Object)findMobEnchant)) continue;
            return true;
        }
        return false;
    }

    public static boolean findMobEnchant(List<MobEnchant> list, MobEnchant findMobEnchant) {
        return list.contains((Object)findMobEnchant);
    }

    public static boolean findMobEnchantFromHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (mobEnchant == null || !((Object)((Object)mobEnchant.getMobEnchant())).equals((Object)findMobEnchant)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAllowMobEnchantFromMob(@Nullable MobEnchant mobEnchant, LivingEntity livingEntity, MobEnchantCapability capability) {
        if (mobEnchant != null && !mobEnchant.isCompatibleMob(livingEntity)) {
            return false;
        }
        for (MobEnchantHandler enchantHandler : capability.getMobEnchants()) {
            if (mobEnchant == null || enchantHandler.getMobEnchant() == null || enchantHandler.getMobEnchant().isCompatibleWith(mobEnchant)) continue;
            return false;
        }
        return true;
    }

    public static int getMobEnchantLevelFromHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (mobEnchant == null || !((Object)((Object)mobEnchant.getMobEnchant())).equals((Object)findMobEnchant)) continue;
            return mobEnchant.getEnchantLevel();
        }
        return 0;
    }

    public static List<MobEnchantmentData> buildEnchantmentList(Random randomIn, int level, boolean allowTresure) {
        ArrayList list = Lists.newArrayList();
        int i = 1;
        if (i <= 0) {
            return list;
        }
        level = level + 1 + randomIn.nextInt(i / 4 + 1) + randomIn.nextInt(i / 4 + 1);
        float f = (randomIn.nextFloat() + randomIn.nextFloat() - 1.0f) * 0.15f;
        List<MobEnchantmentData> list1 = MobEnchantUtils.makeMobEnchantmentDatas(level = Mth.m_14045_((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE), allowTresure);
        if (!list1.isEmpty()) {
            WeightedRandom.m_146317_((Random)randomIn, list1).ifPresent(list::add);
            while (randomIn.nextInt(50) <= level) {
                if (!list.isEmpty()) {
                    MobEnchantUtils.removeIncompatible(list1, (MobEnchantmentData)((Object)Util.m_137509_((List)list)));
                }
                if (list1.isEmpty()) break;
                WeightedRandom.m_146317_((Random)randomIn, list1).ifPresent(list::add);
                level /= 2;
            }
        }
        return list;
    }

    public static List<MobEnchantmentData> makeMobEnchantmentDatas(int p_185291_0_, boolean allowTresure) {
        ArrayList list = Lists.newArrayList();
        block0: for (MobEnchant enchantment : MobEnchants.getRegistry().getValues()) {
            if (enchantment.isTresureEnchant() && !allowTresure) continue;
            for (int i = enchantment.getMaxLevel(); i > enchantment.getMinLevel() - 1; --i) {
                if (p_185291_0_ < enchantment.getMinEnchantability(i) || p_185291_0_ > enchantment.getMaxEnchantability(i)) continue;
                list.add(new MobEnchantmentData(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    private static void removeIncompatible(List<MobEnchantmentData> dataList, MobEnchantmentData data) {
        Iterator<MobEnchantmentData> iterator = dataList.iterator();
        while (iterator.hasNext()) {
            if (data.enchantment.isCompatibleWith(iterator.next().enchantment)) continue;
            iterator.remove();
        }
    }
}

