/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob;

import com.baguchan.enchantwithmob.EnchantConfig;
import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.capability.ItemMobEnchantCapability;
import com.baguchan.enchantwithmob.capability.MobEnchantCapability;
import com.baguchan.enchantwithmob.capability.MobEnchantHandler;
import com.baguchan.enchantwithmob.message.MobEnchantedMessage;
import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.registry.MobEnchants;
import com.baguchan.enchantwithmob.registry.ModItems;
import com.baguchan.enchantwithmob.utils.MobEnchantUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="enchantwithmob")
public class CommonEventHandler {
    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(MobEnchantCapability.class);
        event.register(ItemMobEnchantCapability.class);
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("enchantwithmob", "mob_enchant"), (ICapabilityProvider)new MobEnchantCapability());
        }
        if (event.getObject() instanceof Projectile) {
            event.addCapability(new ResourceLocation("enchantwithmob", "item_mob_enchant"), (ICapabilityProvider)new ItemMobEnchantCapability());
        }
    }

    @SubscribeEvent
    public static void onSpawnEntity(LivingSpawnEvent.SpecialSpawn event) {
        if (event.getEntity() instanceof LivingEntity) {
            LevelAccessor world = event.getLevel();
            Mob livingEntity = event.getEntity();
            if (CommonEventHandler.isSpawnAlwayEnchantableEntity((Entity)livingEntity) && !world.m_5776_()) {
                livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(arg_0 -> CommonEventHandler.lambda$onSpawnEntity$0(world, (LivingEntity)livingEntity, arg_0));
            }
            if (((Boolean)EnchantConfig.COMMON.naturalSpawnEnchantedMob.get()).booleanValue() && CommonEventHandler.isSpawnEnchantableEntity((Entity)event.getEntity()) && (!(livingEntity instanceof Animal) && !(livingEntity instanceof WaterAnimal) || ((Boolean)EnchantConfig.COMMON.spawnEnchantedAnimal.get()).booleanValue()) && event.getSpawnReason() != MobSpawnType.BREEDING && event.getSpawnReason() != MobSpawnType.CONVERSION && event.getSpawnReason() != MobSpawnType.STRUCTURE && event.getSpawnReason() != MobSpawnType.MOB_SUMMONED && world.m_213780_().m_188501_() < 0.005f * (float)world.m_46791_().m_19028_() + world.m_6436_(livingEntity.m_20183_()).m_19056_() * 0.025f && !world.m_5776_()) {
                livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(arg_0 -> CommonEventHandler.lambda$onSpawnEntity$1(world, (LivingEntity)livingEntity, arg_0));
            }
        }
    }

    private static boolean isSpawnAlwayEnchantableEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && ((List)EnchantConfig.COMMON.ALWAY_ENCHANTABLE_MOBS.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
    }

    private static boolean isSpawnEnchantableEntity(Entity entity) {
        return !(entity instanceof Player) && !(entity instanceof ArmorStand) && !(entity instanceof Boat) && !(entity instanceof Minecart) && !((List)EnchantConfig.COMMON.ENCHANT_ON_SPAWN_EXCLUSION_MOBS.get()).contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
    }

    @SubscribeEvent
    public static void onEntitySpawn(LivingSpawnEvent event) {
        Mob livingEntity = event.getEntity();
        if (!livingEntity.f_19853_.f_46443_) {
            livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(arg_0 -> CommonEventHandler.lambda$onEntitySpawn$3((LivingEntity)livingEntity, arg_0));
        }
    }

    @SubscribeEvent
    public static void onUpdateEnchanted(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
            for (MobEnchantHandler enchantHandler : cap.getMobEnchants()) {
                enchantHandler.getMobEnchant().tick(livingEntity, enchantHandler.getEnchantLevel());
            }
            if (cap.isFromOwner() && (!cap.hasOwner() || cap.hasOwner() && livingEntity.m_20280_((Entity)cap.getEnchantOwner().get()) > 512.0)) {
                cap.removeMobEnchantFromOwner(livingEntity);
                livingEntity.m_5496_(SoundEvents.f_12018_, 1.5f, 1.6f);
            }
        });
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (event.getSource().m_7639_() instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)event.getSource().m_7639_();
            attacker.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                if (cap.hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.STRONG.get())) {
                    if (event.getSource().m_7639_() != null && event.getSource().m_7639_() instanceof SnowGolem && event.getAmount() == 0.0f) {
                        event.setAmount(CommonEventHandler.getDamageAddition(1.0f, cap));
                    } else if (event.getAmount() > 0.0f) {
                        event.setAmount(CommonEventHandler.getDamageAddition(event.getAmount(), cap));
                    }
                }
                if (cap.hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.POISON.get())) {
                    int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.POISON.get());
                    if (event.getAmount() > 0.0f && attacker.m_217043_().m_188501_() < (float)i * 0.125f) {
                        livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 60 * i, 0), (Entity)attacker);
                    }
                }
            });
            livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                if (cap.hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.THORN.get())) {
                    int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.THORN.get());
                    if (event.getSource().m_7640_() == attacker && !event.getSource().m_19372_() && livingEntity.m_217043_().m_188501_() < (float)i * 0.1f) {
                        attacker.m_6469_(DamageSource.m_19335_((Entity)livingEntity), CommonEventHandler.getThornDamage(event.getAmount(), cap));
                    }
                }
            });
        }
        livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
            if (event.getSource() != DamageSource.f_19313_ && cap.hasEnchant() && MobEnchantUtils.findMobEnchantFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.PROTECTION.get())) {
                event.setAmount(CommonEventHandler.getDamageReduction(event.getAmount(), cap));
            }
        });
        livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
            if (cap.hasEnchant()) {
                event.setAmount(CommonEventHandler.getBonusMobEnchantDamageReduction(event.getAmount(), cap));
            }
        });
    }

    public static float getDamageAddition(float damage, MobEnchantCapability cap) {
        int level = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.STRONG.get());
        if (level > 0) {
            damage += 1.0f + (float)Math.max(0, level - 1) * 1.0f;
        }
        return damage;
    }

    public static float getDamageReduction(float damage, MobEnchantCapability cap) {
        int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.PROTECTION.get());
        if (i > 0) {
            damage = (float)((double)damage - (double)Mth.m_14107_((double)((double)damage * (double)((float)i * 0.15f))));
        }
        return damage;
    }

    public static float getBonusMobEnchantDamageReduction(float damage, MobEnchantCapability cap) {
        int i = cap.getMobEnchants().size();
        if (i > 0) {
            damage = (float)((double)damage - (double)Mth.m_14107_((double)((double)damage * (double)((float)i * 0.05f))));
        }
        return damage;
    }

    public static float getThornDamage(float damage, MobEnchantCapability cap) {
        int i = MobEnchantUtils.getMobEnchantLevelFromHandler(cap.getMobEnchants(), (MobEnchant)MobEnchants.THORN.get());
        if (i > 0) {
            damage = Mth.m_14107_((double)((double)damage * (double)((float)i * 0.15f)));
        }
        return damage;
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.EntityInteract event) {
        LivingEntity target;
        ItemStack stack = event.getItemStack();
        Entity entityTarget = event.getTarget();
        if (stack.m_41720_() == ModItems.MOB_ENCHANT_BOOK.get() && !event.getEntity().m_36335_().m_41519_(stack.m_41720_()) && entityTarget instanceof LivingEntity) {
            target = (LivingEntity)entityTarget;
            if (MobEnchantUtils.hasMobEnchant(stack)) {
                target.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                    boolean[] flag = new boolean[]{false};
                    flag[0] = MobEnchantUtils.addItemMobEnchantToEntity(stack, target, cap);
                    if (flag[0]) {
                        event.getEntity().m_5496_(SoundEvents.f_11887_, 1.0f, 1.0f);
                        stack.m_41622_(1, (LivingEntity)event.getEntity(), entity -> entity.m_21190_(event.getHand()));
                        event.getEntity().m_36335_().m_41524_(stack.m_41720_(), 60);
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        event.setCanceled(true);
                    } else {
                        event.getEntity().m_5661_((Component)Component.m_237115_((String)"enchantwithmob.cannot.enchant"), true);
                        event.getEntity().m_36335_().m_41524_(stack.m_41720_(), 20);
                        event.setCancellationResult(InteractionResult.FAIL);
                        event.setCanceled(true);
                    }
                });
            }
        }
        if (stack.m_41720_() == ModItems.MOB_UNENCHANT_BOOK.get() && !event.getEntity().m_36335_().m_41519_(stack.m_41720_()) && entityTarget instanceof LivingEntity) {
            target = (LivingEntity)entityTarget;
            target.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                MobEnchantUtils.removeMobEnchantToEntity(target, cap);
                event.getEntity().m_5496_(SoundEvents.f_11887_, 1.0f, 1.0f);
                stack.m_41622_(1, (LivingEntity)event.getEntity(), entity -> entity.m_21190_(event.getHand()));
                event.getEntity().m_36335_().m_41524_(stack.m_41720_(), 80);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            });
        }
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack stack1 = event.getLeft();
        ItemStack stack2 = event.getRight();
        if (stack1.m_41720_() == ModItems.MOB_ENCHANT_BOOK.get() && stack2.m_41720_() == ModItems.MOB_ENCHANT_BOOK.get()) {
            Map<MobEnchant, Integer> map = MobEnchantUtils.getEnchantments(stack1);
            Map<MobEnchant, Integer> map1 = MobEnchantUtils.getEnchantments(stack2);
            boolean flag2 = false;
            boolean flag3 = false;
            for (MobEnchant enchantment1 : map1.keySet()) {
                int j2;
                if (enchantment1 == null) continue;
                int i2 = map.getOrDefault(enchantment1, 0);
                j2 = i2 == (j2 = map1.get(enchantment1).intValue()) ? j2 + 1 : Math.max(j2, i2);
                boolean flag1 = true;
                for (MobEnchant enchantment : map.keySet()) {
                    if (enchantment == enchantment1 || enchantment1.isCompatibleWith(enchantment)) continue;
                    flag1 = false;
                }
                if (!flag1) {
                    flag3 = true;
                    continue;
                }
                flag2 = true;
                if (j2 > enchantment1.getMaxLevel()) {
                    j2 = enchantment1.getMaxLevel();
                }
                map.put(enchantment1, j2);
                int k3 = 0;
                switch (enchantment1.getRarity()) {
                    case COMMON: {
                        k3 = 1;
                        break;
                    }
                    case UNCOMMON: {
                        k3 = 2;
                        break;
                    }
                    case RARE: {
                        k3 = 4;
                        break;
                    }
                    case VERY_RARE: {
                        k3 = 8;
                    }
                }
            }
            if (!stack1.m_41619_()) {
                int k2 = stack1.m_41610_();
                if (!stack2.m_41619_() && k2 < stack2.m_41610_()) {
                    k2 = stack2.m_41610_();
                }
                ItemStack stack3 = new ItemStack((ItemLike)stack1.m_41720_());
                MobEnchantUtils.setEnchantments(map, stack3);
                stack3.m_41742_(4 + k2);
                event.setOutput(stack3);
                event.setCost(4 + k2);
                event.setMaterialCost(1);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            player.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(handler -> {
                for (int i = 0; i < handler.getMobEnchants().size(); ++i) {
                    EnchantWithMob.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MobEnchantedMessage((Entity)player, handler.getMobEnchants().get(i)));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onExpDropped(LivingExperienceDropEvent event) {
        LivingEntity entity = event.getEntity();
        entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
            if (cap.hasEnchant()) {
                event.setDroppedExperience(event.getDroppedExperience() + MobEnchantUtils.getExperienceFromMob(cap));
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player playerEntity = event.getEntity();
        playerEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(handler -> {
            for (int i = 0; i < handler.getMobEnchants().size(); ++i) {
                EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> playerEntity), (Object)new MobEnchantedMessage((Entity)playerEntity, handler.getMobEnchants().get(i)));
            }
        });
    }

    private static /* synthetic */ void lambda$onEntitySpawn$3(LivingEntity livingEntity, MobEnchantCapability cap) {
        if (cap.hasEnchant()) {
            for (int i = 0; i < cap.getMobEnchants().size(); ++i) {
                MobEnchantedMessage message = new MobEnchantedMessage((Entity)livingEntity, cap.getMobEnchants().get(i));
                EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> livingEntity), (Object)message);
            }
        }
        if (cap.isFromOwner() && (!cap.hasOwner() || cap.hasOwner() && livingEntity.m_20280_((Entity)cap.getEnchantOwner().get()) > 512.0)) {
            cap.removeMobEnchantFromOwner(livingEntity);
            livingEntity.m_5496_(SoundEvents.f_12018_, 1.5f, 1.6f);
        }
    }

    private static /* synthetic */ void lambda$onSpawnEntity$1(LevelAccessor world, LivingEntity livingEntity, MobEnchantCapability cap) {
        int i = 0;
        float difficultScale = world.m_6436_(livingEntity.m_20183_()).m_19056_() - 0.2f;
        switch (world.m_46791_()) {
            case EASY: {
                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)20.0f);
                MobEnchantUtils.addRandomEnchantmentToEntity(livingEntity, cap, world.m_213780_(), i, true);
                break;
            }
            case NORMAL: {
                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)40.0f);
                MobEnchantUtils.addRandomEnchantmentToEntity(livingEntity, cap, world.m_213780_(), i, true);
                break;
            }
            case HARD: {
                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(10)) * difficultScale), (float)1.0f, (float)50.0f);
                MobEnchantUtils.addRandomEnchantmentToEntity(livingEntity, cap, world.m_213780_(), i, true);
            }
        }
        livingEntity.m_21153_(livingEntity.m_21233_());
    }

    private static /* synthetic */ void lambda$onSpawnEntity$0(LevelAccessor world, LivingEntity livingEntity, MobEnchantCapability cap) {
        int i = 0;
        float difficultScale = world.m_6436_(livingEntity.m_20183_()).m_19056_() - 0.2f;
        switch (world.m_46791_()) {
            case EASY: {
                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)20.0f);
                MobEnchantUtils.addRandomEnchantmentToEntity(livingEntity, cap, world.m_213780_(), i, true);
                break;
            }
            case NORMAL: {
                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(5)) * difficultScale), (float)1.0f, (float)40.0f);
                MobEnchantUtils.addRandomEnchantmentToEntity(livingEntity, cap, world.m_213780_(), i, true);
                break;
            }
            case HARD: {
                i = (int)Mth.m_14036_((float)((float)(5 + world.m_213780_().m_188503_(10)) * difficultScale), (float)1.0f, (float)50.0f);
                MobEnchantUtils.addRandomEnchantmentToEntity(livingEntity, cap, world.m_213780_(), i, true);
            }
        }
        livingEntity.m_21153_(livingEntity.m_21233_());
    }
}

