/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.client;

import com.baguchan.enchantwithmob.EnchantWithMob;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="enchantwithmob", value={Dist.CLIENT})
public class ClientEventHandler {
    protected static final RenderStateShard.LightmapStateShard LIGHTMAP = new RenderStateShard.LightmapStateShard(true);
    protected static final RenderStateShard.TransparencyStateShard ADDITIVE_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("additive_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ENTITY_GLINT_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::m_172747_);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ENERGY_SWIRL_SHADER = new RenderStateShard.ShaderStateShard(GameRenderer::m_172703_);
    protected static final RenderStateShard.CullStateShard NO_CULL = new RenderStateShard.CullStateShard(false);
    protected static final RenderStateShard.TexturingStateShard ENTITY_GLINT_TEXTURING = new RenderStateShard.TexturingStateShard("entity_glint_texturing", () -> ClientEventHandler.setupGlintTexturing(0.16f), () -> RenderSystem.m_157423_());

    @SubscribeEvent
    public static void renderEnchantBeam(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> event) {
        PoseStack matrixStack = event.getPoseStack();
        MultiBufferSource bufferBuilder = event.getMultiBufferSource();
        float particalTick = event.getPartialTick();
        event.getEntity().getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
            LivingEntity entity;
            if (cap.hasOwner() && (entity = cap.getEnchantOwner().get()) != null) {
                ClientEventHandler.renderBeam(event.getEntity(), particalTick, matrixStack, bufferBuilder, (Entity)entity, (LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>>)event.getRenderer());
            }
        });
    }

    public static RenderType enchantBeamSwirl() {
        return RenderType.m_173215_((String)"entity_enchant_glint", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_ENERGY_SWIRL_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ItemRenderer.f_115092_, false, false)).m_110661_(NO_CULL).m_110671_(LIGHTMAP).m_110685_(ADDITIVE_TRANSPARENCY).m_110683_(ENTITY_GLINT_TEXTURING).m_110691_(false));
    }

    private static void renderBeam(LivingEntity p_229118_1_, float p_229118_2_, PoseStack p_229118_3_, MultiBufferSource p_229118_4_, Entity p_229118_5_, LivingEntityRenderer<LivingEntity, EntityModel<LivingEntity>> renderer) {
        float tick = (float)p_229118_1_.f_19797_ + p_229118_2_;
        p_229118_3_.m_85836_();
        Vec3 vector3d = p_229118_5_.m_7398_(p_229118_2_);
        double d0 = (double)(Mth.m_14179_((float)p_229118_2_, (float)p_229118_1_.f_20883_, (float)p_229118_1_.f_20884_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vector3d vector3d1 = new Vector3d(0.0, (double)p_229118_1_.m_20192_() / 2.0, 0.0);
        double d1 = Math.cos(d0) * vector3d1.f_86216_ + Math.sin(d0) * vector3d1.f_86214_;
        double d2 = Math.sin(d0) * vector3d1.f_86216_ - Math.cos(d0) * vector3d1.f_86214_;
        double d3 = Mth.m_14139_((double)p_229118_2_, (double)p_229118_1_.f_19854_, (double)p_229118_1_.m_20185_()) + d1;
        double d4 = Mth.m_14139_((double)p_229118_2_, (double)p_229118_1_.f_19855_, (double)p_229118_1_.m_20186_()) + vector3d1.f_86215_;
        double d5 = Mth.m_14139_((double)p_229118_2_, (double)p_229118_1_.f_19856_, (double)p_229118_1_.m_20189_()) + d2;
        p_229118_3_.m_85837_(d1, vector3d1.f_86215_, d2);
        float f = (float)(vector3d.f_82479_ - d3);
        float f1 = (float)(vector3d.f_82480_ - d4);
        float f2 = (float)(vector3d.f_82481_ - d5);
        float f3 = 0.1f;
        VertexConsumer ivertexbuilder = p_229118_4_.m_6299_(ClientEventHandler.enchantBeamSwirl());
        Matrix4f matrix4f = p_229118_3_.m_85850_().m_85861_();
        float f4 = Mth.m_14195_((float)(f * f + f2 * f2)) * 0.1f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = new BlockPos(p_229118_1_.m_20299_(p_229118_2_));
        BlockPos blockpos1 = new BlockPos(p_229118_5_.m_20299_(p_229118_2_));
        int i = ClientEventHandler.getBlockLightLevel((Entity)p_229118_1_, blockpos);
        int j = ClientEventHandler.getBlockLightLevel(p_229118_5_, blockpos1);
        int k = p_229118_1_.f_19853_.m_45517_(LightLayer.SKY, blockpos);
        int l = p_229118_1_.f_19853_.m_45517_(LightLayer.SKY, blockpos1);
        ClientEventHandler.renderSide(ivertexbuilder, matrix4f, f, f1, f2, i, j, k, l, 0.05f, 0.1f, f5, f6);
        ClientEventHandler.renderSide(ivertexbuilder, matrix4f, f, f1, f2, i, j, k, l, 0.1f, 0.0f, f5, f6);
        p_229118_3_.m_85849_();
    }

    public static void renderSide(VertexConsumer p_229119_0_, Matrix4f p_229119_1_, float p_229119_2_, float p_229119_3_, float p_229119_4_, int p_229119_5_, int p_229119_6_, int p_229119_7_, int p_229119_8_, float p_229119_9_, float p_229119_10_, float p_229119_11_, float p_229119_12_) {
        int i = 24;
        for (int j = 0; j < 24; ++j) {
            float f = (float)j / 23.0f;
            int k = (int)Mth.m_14179_((float)f, (float)p_229119_5_, (float)p_229119_6_);
            int l = (int)Mth.m_14179_((float)f, (float)p_229119_7_, (float)p_229119_8_);
            int i1 = LightTexture.m_109885_((int)k, (int)l);
            ClientEventHandler.addVertexPair(p_229119_0_, p_229119_1_, i1, p_229119_2_, p_229119_3_, p_229119_4_, p_229119_9_, p_229119_10_, 24, j, false, p_229119_11_, p_229119_12_);
            ClientEventHandler.addVertexPair(p_229119_0_, p_229119_1_, i1, p_229119_2_, p_229119_3_, p_229119_4_, p_229119_9_, p_229119_10_, 24, j + 1, true, p_229119_11_, p_229119_12_);
        }
    }

    public static void addVertexPair(VertexConsumer p_229120_0_, Matrix4f p_229120_1_, int p_229120_2_, float p_229120_3_, float p_229120_4_, float p_229120_5_, float p_229120_6_, float p_229120_7_, int p_229120_8_, int p_229120_9_, boolean p_229120_10_, float p_229120_11_, float p_229120_12_) {
        float f = 0.5f;
        float f1 = 0.4f;
        float f2 = 0.3f;
        if (p_229120_9_ % 2 == 0) {
            f *= 0.7f;
            f1 *= 0.7f;
            f2 *= 0.7f;
        }
        float f3 = (float)p_229120_9_ / (float)p_229120_8_;
        float f4 = p_229120_3_ * f3;
        float f5 = p_229120_4_ > 0.0f ? p_229120_4_ * f3 * f3 : p_229120_4_ - p_229120_4_ * (1.0f - f3) * (1.0f - f3);
        float f6 = p_229120_5_ * f3;
        if (!p_229120_10_) {
            p_229120_0_.m_85982_(p_229120_1_, f4 + p_229120_11_, f5 + p_229120_6_ - p_229120_7_, f6 - p_229120_12_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(p_229120_2_).m_5752_();
        }
        p_229120_0_.m_85982_(p_229120_1_, f4 - p_229120_11_, f5 + p_229120_7_, f6 + p_229120_12_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(p_229120_2_).m_5752_();
        if (p_229120_10_) {
            p_229120_0_.m_85982_(p_229120_1_, f4 + p_229120_11_, f5 + p_229120_6_ - p_229120_7_, f6 - p_229120_12_).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(p_229120_2_).m_5752_();
        }
    }

    protected static int getSkyLightLevel(Entity p_239381_1_, BlockPos p_239381_2_) {
        return p_239381_1_.f_19853_.m_45517_(LightLayer.SKY, p_239381_2_);
    }

    protected static int getBlockLightLevel(Entity p_225624_1_, BlockPos p_225624_2_) {
        return p_225624_1_.m_6060_() ? 15 : p_225624_1_.f_19853_.m_45517_(LightLayer.BLOCK, p_225624_2_);
    }

    private static void setupGlintTexturing(float p_110187_) {
        long var1 = Util.m_137550_() * 8L;
        float var3 = (float)(var1 % 110000L) / 110000.0f;
        float var4 = (float)(var1 % 30000L) / 30000.0f;
        Matrix4f var5 = Matrix4f.m_27653_((float)(-var3), (float)var4, (float)0.0f);
        var5.m_27646_(Vector3f.f_122227_.m_122240_(10.0f));
        var5.m_27644_(Matrix4f.m_27632_((float)p_110187_, (float)p_110187_, (float)p_110187_));
        RenderSystem.m_157459_((Matrix4f)var5);
    }
}

