/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.item;

import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.registry.MobEnchants;
import com.baguchan.enchantwithmob.utils.MobEnchantUtils;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EnchantersBookItem
extends Item {
    private final TargetingConditions enchantTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();
    private final TargetingConditions alreadyEnchantTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_().m_26888_(entity -> entity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).map(mob -> mob.hasEnchant()).orElse(false));

    public EnchantersBookItem(Item.Properties properties) {
        super(properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!MobEnchantUtils.hasMobEnchant(stack)) return super.m_7203_(level, playerIn, handIn);
        List list = level.m_45971_(LivingEntity.class, this.enchantTargeting, (LivingEntity)playerIn, playerIn.m_20191_().m_82400_(16.0));
        List hasEnchantedMoblist = level.m_45971_(LivingEntity.class, this.alreadyEnchantTargeting, (LivingEntity)playerIn, playerIn.m_20191_().m_82400_(16.0));
        if (hasEnchantedMoblist.isEmpty() || hasEnchantedMoblist.size() < 5) {
            if (!list.isEmpty()) {
                int size = list.size();
                boolean[] flag = new boolean[]{false};
                for (int i = 0; i < size; ++i) {
                    LivingEntity enchantedMob = (LivingEntity)list.get(i);
                    if (i >= 5) break;
                    if (enchantedMob.m_6779_((LivingEntity)playerIn) || playerIn == enchantedMob) continue;
                    enchantedMob.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                        if (!cap.hasEnchant()) {
                            if (flag[0]) {
                                MobEnchantUtils.addItemMobEnchantToEntity(stack, enchantedMob, cap);
                            } else {
                                flag[0] = MobEnchantUtils.addItemMobEnchantToEntity(stack, enchantedMob, cap);
                            }
                            cap.addOwner(enchantedMob, (LivingEntity)playerIn);
                        }
                    });
                }
                if (!flag[0]) return super.m_7203_(level, playerIn, handIn);
                playerIn.m_5496_(SoundEvents.f_11887_, 1.0f, 1.0f);
                stack.m_41622_(1, (LivingEntity)playerIn, entity -> entity.m_21190_(handIn));
                playerIn.m_36335_().m_41524_(stack.m_41720_(), 40);
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            playerIn.m_5661_((Component)Component.m_237115_((String)"enchantwithmob.cannot.no_enchantable_ally"), true);
            playerIn.m_36335_().m_41524_(stack.m_41720_(), 20);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        playerIn.m_5661_((Component)Component.m_237115_((String)"enchantwithmob.cannot.no_enchantable_ally"), true);
        playerIn.m_36335_().m_41524_(stack.m_41720_(), 20);
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_6787_(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.m_220152_(p_41391_)) {
            for (MobEnchant enchant : MobEnchants.getRegistry().get().getValues()) {
                ItemStack stack = new ItemStack((ItemLike)this);
                MobEnchantUtils.addMobEnchantToItemStack(stack, enchant, enchant.getMaxLevel());
                p_41392_.add((Object)stack);
            }
        }
    }

    public static ListTag getEnchantmentList(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        return compoundnbt != null ? compoundnbt.m_128437_("StoredMobEnchants", 10) : new ListTag();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag p_41424_) {
        super.m_7373_(stack, level, tooltip, p_41424_);
        ChatFormatting[] textformatting2 = new ChatFormatting[]{ChatFormatting.DARK_PURPLE};
        tooltip.add((Component)Component.m_237115_((String)"mobenchant.enchantwithmob.enchanter_book.tooltip").m_130944_(textformatting2));
        tooltip.add((Component)Component.m_237115_((String)"mobenchant.enchantwithmob.enchanter_book.tooltip2").m_130944_(textformatting2));
        if (MobEnchantUtils.hasMobEnchant(stack)) {
            ListTag listnbt = MobEnchantUtils.getEnchantmentListForNBT(stack.m_41783_());
            for (int i = 0; i < listnbt.size(); ++i) {
                CompoundTag compoundnbt = listnbt.m_128728_(i);
                MobEnchant mobEnchant = MobEnchantUtils.getEnchantFromNBT(compoundnbt);
                int enchantmentLevel = MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt);
                if (mobEnchant == null) continue;
                ChatFormatting[] textformatting = new ChatFormatting[]{ChatFormatting.AQUA};
                tooltip.add((Component)Component.m_237115_((String)("mobenchant." + MobEnchants.getRegistry().get().getKey((Object)mobEnchant).m_135827_() + "." + MobEnchants.getRegistry().get().getKey((Object)mobEnchant).m_135815_())).m_130944_(textformatting).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)("enchantment.level." + enchantmentLevel)).m_130944_(textformatting)));
            }
            ArrayList list1 = Lists.newArrayList();
            for (int i = 0; i < listnbt.size(); ++i) {
                Map<Attribute, AttributeModifier> map;
                CompoundTag compoundnbt = listnbt.m_128728_(i);
                MobEnchant mobEnchant = MobEnchantUtils.getEnchantFromNBT(compoundnbt);
                int mobEnchantLevel = MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt);
                if (mobEnchant == null || (map = mobEnchant.getAttributeModifierMap()).isEmpty()) continue;
                for (Map.Entry<Attribute, AttributeModifier> entry : map.entrySet()) {
                    AttributeModifier attributemodifier = entry.getValue();
                    AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.m_22214_(), mobEnchant.getAttributeModifierAmount(mobEnchantLevel, attributemodifier), attributemodifier.m_22217_());
                    list1.add(new Pair((Object)entry.getKey(), (Object)attributemodifier1));
                }
            }
            if (!list1.isEmpty()) {
                tooltip.add((Component)Component.m_237115_((String)"mobenchant.enchantwithmob.when_ehcnanted").m_130940_(ChatFormatting.DARK_PURPLE));
                for (Pair pair : list1) {
                    AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                    double d0 = attributemodifier2.m_22218_();
                    double d1 = attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier2.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributemodifier2.m_22218_() : attributemodifier2.m_22218_() * 100.0;
                    if (d0 > 0.0) {
                        tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                        continue;
                    }
                    if (!(d0 < 0.0)) continue;
                    tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier2.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)pair.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
                }
            }
        }
    }

    public boolean m_5812_(ItemStack p_77636_1_) {
        return true;
    }
}

