/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.mobenchant;

import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.registry.MobEnchants;
import com.baguchan.enchantwithmob.utils.MobEnchantUtils;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="enchantwithmob")
public class PoisonCloudMobEnchant
extends MobEnchant {
    public PoisonCloudMobEnchant(MobEnchant.Properties properties) {
        super(properties);
    }

    @Override
    public int getMinEnchantability(int enchantmentLevel) {
        return 20;
    }

    @Override
    public int getMaxEnchantability(int enchantmentLevel) {
        return 50;
    }

    @Override
    public void tick(LivingEntity entity, int level) {
        super.tick(entity, level);
    }

    @Override
    public boolean isCompatibleMob(LivingEntity livingEntity) {
        return (livingEntity instanceof Player || livingEntity instanceof RangedAttackMob) && !(livingEntity instanceof Witch);
    }

    @Override
    protected boolean canApplyTogether(MobEnchant ench) {
        return ench != MobEnchants.POISON.get() && super.canApplyTogether(ench);
    }

    @Override
    public boolean isTresureEnchant() {
        return true;
    }

    @SubscribeEvent
    public static void onImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            if (!PoisonCloudMobEnchant.shooterIsLiving(projectile)) {
                return;
            }
            LivingEntity owner = (LivingEntity)projectile.m_37282_();
            MobEnchantUtils.executeIfPresent(owner, (MobEnchant)MobEnchants.POISON_CLOUD.get(), () -> {
                if (!(projectile instanceof AbstractArrow) || !projectile.m_20096_()) {
                    AreaEffectCloud areaeffectcloud = new AreaEffectCloud(owner.f_19853_, event.getRayTraceResult().m_82450_().f_82479_, event.getRayTraceResult().m_82450_().f_82480_, event.getRayTraceResult().m_82450_().f_82481_);
                    areaeffectcloud.m_19712_(1.0f);
                    areaeffectcloud.m_19732_(-0.05f);
                    areaeffectcloud.m_19740_(10);
                    areaeffectcloud.m_19734_(110);
                    areaeffectcloud.m_19718_(owner);
                    areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
                    areaeffectcloud.m_19716_(new MobEffectInstance(MobEffects.f_19614_, 60, 0));
                    owner.f_19853_.m_7967_((Entity)areaeffectcloud);
                }
            });
        }
    }

    public static boolean shooterIsLiving(Projectile projectile) {
        return projectile.m_37282_() != null && projectile.m_37282_() instanceof LivingEntity;
    }
}

