/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="enchantwithmob", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EnchantConfig {
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair2.getRight();
        CLIENT = (Client)specPair2.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> buffedDragon;
        public final ForgeConfigSpec.BooleanValue naturalSpawnEnchantedMob;
        public final ForgeConfigSpec.BooleanValue spawnEnchantedAnimal;
        public final ForgeConfigSpec.BooleanValue enchantYourSelf;
        public final ForgeConfigSpec.BooleanValue changeSizeWhenEnchant;
        public final ForgeConfigSpec.BooleanValue dungeonsLikeHealth;
        public final ForgeConfigSpec.BooleanValue bigYourSelf;
        public final ForgeConfigSpec.BooleanValue universalEnchant;
        public final ForgeConfigSpec.DoubleValue difficultyBasePercent;
        public final ForgeConfigSpec.DoubleValue effectiveBasePercent;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ENCHANT_ON_SPAWN_EXCLUSION_MOBS;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ALWAY_ENCHANTABLE_MOBS;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ALWAY_ENCHANTABLE_ANCIENT_MOBS;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> DISABLE_ENCHANTS;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> DISABLE_POISON_CLOUD_PROJECTILE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> DISABLE_MULTISHOT_PROJECTILE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> WHITELIST_SHOOT_ENTITY;

        public Common(ForgeConfigSpec.Builder builder) {
            this.naturalSpawnEnchantedMob = builder.comment("Enable the the spawning of enchanted mobs. [true / false]").translation("enchantwithmob.config.naturalSpawnEnchantedMob").define("Enchanted Mob can Spawn Natural", true);
            this.ENCHANT_ON_SPAWN_EXCLUSION_MOBS = builder.comment("Disables specific mob from receiveing enchantments on spawn. Use the full name, eg: minecraft:ender_dragon.").define("enchantOnSpawnExclusionMobs", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:wither", "minecraft:ender_dragon"}));
            this.ALWAY_ENCHANTABLE_MOBS = builder.comment("Allow the specific mob from alway receiveing enchantments on spawn. Use the full name, eg: minecraft:zombie.").define("alwayEnchantableMobs", (Object)Lists.newArrayList());
            this.ALWAY_ENCHANTABLE_ANCIENT_MOBS = builder.comment("Allow the specific mob from alway receiveing enchantments as Ancient Mob on spawn(This feature may break for balance so be careful). Use the full name, eg: minecraft:zombie.").define("alwayEnchantableAncientMobs", (Object)Lists.newArrayList());
            this.DISABLE_ENCHANTS = builder.comment("Disables the specific mob enchant. Use the full name(This config only disabled mob enchant when mob spawn. not mean delete complete, eg: enchantwithmob:thorn.").define("disableMobEnchants", (Object)Lists.newArrayList());
            this.DISABLE_POISON_CLOUD_PROJECTILE = builder.comment("Disables the poison cloud for projectile. Use the full name(eg: minecraft:potion.").define("disablePoisonCloudProjectiles", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:potion", "minecraft:experience_bottle", "minecraft:ender_pearl", "minecraft:egg", "earthmobsmod:smelly_egg"}));
            this.DISABLE_MULTISHOT_PROJECTILE = builder.comment("Disables the multi shot for projectile. Use the full name(eg: minecraft:potion.").define("disableMultiShotProjectiles", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:experience_bottle", "minecraft:ender_pearl", "minecraft:eye_of_ender", "minecraft:egg", "earthmobsmod:smelly_egg", "conjurer_illager:throwing_card", "conjurer_illager:bouncy_ball"}));
            this.WHITELIST_SHOOT_ENTITY = builder.comment("Whitelist the projectile mob enchant for mob. Use the full name(eg: minecraft:zombie.").define("whitelistShootEntity", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:skeleton", "minecraft:pillager", "minecraft:shulker", "minecraft:llama", "conjurer_illager:conjurer", "earthmobsmod:bone_spider", "earthmobsmod:lobber_zombie", "earthmobsmod:lobber_drowned", "earthmobsmod:melon_golem", "minecraft:piglin", "minecraft:snow_golem", "minecraft:player"}));
            this.buffedDragon = builder.comment("Set the MobEnchant on the EnderDragon. If you want more harder fight. should set it! eg: enchantwithmob:thorn.").define("Buffed Dragon", (Object)Lists.newArrayList());
            this.spawnEnchantedAnimal = builder.comment("Enable the the spawning of enchanted animal mobs. [true / false]").translation("enchantwithmob.config.spawnEnchantedAnimal").define("Enchanted Animal can Spawn Natural", false);
            this.enchantYourSelf = builder.comment("Enable enchanting yourself. [true / false]").translation("enchantwithmob.config.enchantYourSelf").define("Enchant yourself", true);
            this.changeSizeWhenEnchant = builder.comment("Enable Change Size When Enchanted. [true / false]").translation("enchantwithmob.config.changeSizeWhenEnchant").define("Change Size", false);
            this.dungeonsLikeHealth = builder.comment("Enable Increase Health like Dungeons When Enchanted. [true / false]").translation("enchantwithmob.config.dungeonsLikeHealth").define("Increase Health like Dungeons", false);
            this.bigYourSelf = builder.comment("Enable Player More Bigger When You have Huge Enchant. [true / false]").translation("enchantwithmob.config.bigYourSelf").define("Big Your Self", false);
            this.universalEnchant = builder.comment("Enable All MobEnchant for all mob. [true / false]").define("UniversalEnchant", false);
            this.difficultyBasePercent = builder.comment("Set The Difficulty Base Enchanted Mob Spawn Percent. [(Difficulty Base Percent * Difficulty id) + (Effective Difficulty Percent * Effective Difficulty)]").defineInRange("Difficulty Enchanted Spawn Percent", 0.005, 0.0, 1.0);
            this.effectiveBasePercent = builder.comment("Set The Effective Difficulty Base Enchanted Mob Spawn Percent [(Difficulty Base Percent * Difficulty id) + (Effective Difficulty Percent * Effective Difficulty)]").defineInRange("Effective Difficulty Enchanted Spawn Percent", 0.025, 0.0, 1.0);
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue showEnchantedMobHud;
        public final ForgeConfigSpec.BooleanValue disablePoisonParticle;
        public final ForgeConfigSpec.BooleanValue disableAuraRender;

        public Client(ForgeConfigSpec.Builder builder) {
            this.showEnchantedMobHud = builder.translation("enchantwithmob.config.showEnchantedMobHud").define("Show Enchanted Mob Hud", true);
            this.disablePoisonParticle = builder.comment("Disable Poison Mob Enchant Particle. [true / false]").translation("enchantwithmob.config.disablePoisonParticle").define("Disable Poison Particle", true);
            this.disableAuraRender = builder.comment("Disable Aura Render. [true / false]").define("Disable Aura Render", true);
        }
    }
}

