/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.loot;

import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.ModItems;
import baguchan.enchantwithmob.registry.ModLootItemFunctions;
import baguchan.enchantwithmob.registry.ModRegistry;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import net.minecraft.class_5819;
import org.slf4j.Logger;

public class MobEnchantRandomlyFunction
extends class_120 {
    private static final Logger LOGGER = LogUtils.getLogger();
    final List<MobEnchant> enchantments;

    public MobEnchantRandomlyFunction(class_5341[] p_80418_, Collection<MobEnchant> p_80419_) {
        super(p_80418_);
        this.enchantments = ImmutableList.copyOf(p_80419_);
    }

    public class_5339 method_29321() {
        return ModLootItemFunctions.MOB_ENCHANT_RANDOMLY_FUNCTION;
    }

    public class_1799 method_522(class_1799 p_80429_, class_47 p_80430_) {
        MobEnchant enchantment;
        class_5819 randomsource = p_80430_.method_294();
        if (this.enchantments.isEmpty()) {
            boolean flag = p_80429_.method_31574(class_1802.field_8529) || p_80429_.method_31574(ModItems.MOB_ENCHANT_BOOK);
            List list = ModRegistry.MOB_ENCHANT.method_40276().method_10220().filter(MobEnchant::isOnlyChest).filter(p_80436_ -> flag).collect(Collectors.toList());
            if (list.isEmpty()) {
                LOGGER.warn("Couldn't find a compatible enchantment for {}", (Object)p_80429_);
                return p_80429_;
            }
            enchantment = (MobEnchant)list.get(randomsource.method_43048(list.size()));
        } else {
            enchantment = this.enchantments.get(randomsource.method_43048(this.enchantments.size()));
        }
        return MobEnchantRandomlyFunction.enchantItem(p_80429_, enchantment, randomsource);
    }

    private static class_1799 enchantItem(class_1799 p_230980_, MobEnchant p_230981_, class_5819 p_230982_) {
        int i = class_3532.method_15395((class_5819)p_230982_, (int)p_230981_.getMinLevel(), (int)p_230981_.getMaxLevel());
        if (p_230980_.method_31574(class_1802.field_8529)) {
            p_230980_ = new class_1799((class_1935)ModItems.MOB_ENCHANT_BOOK);
            MobEnchantUtils.addMobEnchantToItemStack(p_230980_, p_230981_, i);
        } else {
            MobEnchantUtils.addMobEnchantToItemStack(p_230980_, p_230981_, i);
        }
        return p_230980_;
    }

    public static Builder randomMobEnchant() {
        return new Builder();
    }

    public static class_120.class_121<?> randomApplicableMobEnchant() {
        return MobEnchantRandomlyFunction.method_520(p_80438_ -> new MobEnchantRandomlyFunction((class_5341[])p_80438_, (Collection<MobEnchant>)ImmutableList.of()));
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        private final Set<MobEnchant> enchantments = Sets.newHashSet();

        protected Builder getThis() {
            return this;
        }

        public Builder withMobEnchant(MobEnchant p_80445_) {
            this.enchantments.add(p_80445_);
            return this;
        }

        public class_117 method_515() {
            return new MobEnchantRandomlyFunction(this.method_526(), this.enchantments);
        }
    }

    public static class Serializer
    extends class_120.class_123<MobEnchantRandomlyFunction> {
        public void serialize(JsonObject p_80454_, MobEnchantRandomlyFunction p_80455_, JsonSerializationContext p_80456_) {
            super.method_529(p_80454_, (class_120)p_80455_, p_80456_);
            if (!p_80455_.enchantments.isEmpty()) {
                JsonArray jsonarray = new JsonArray();
                for (MobEnchant enchantment : p_80455_.enchantments) {
                    class_2960 resourcelocation = ModRegistry.MOB_ENCHANT.method_10221((Object)enchantment);
                    if (resourcelocation == null) {
                        throw new IllegalArgumentException("Don't know how to serialize enchantment " + enchantment);
                    }
                    jsonarray.add((JsonElement)new JsonPrimitive(resourcelocation.toString()));
                }
                p_80454_.add("enchantments", (JsonElement)jsonarray);
            }
        }

        public MobEnchantRandomlyFunction deserialize(JsonObject p_80450_, JsonDeserializationContext p_80451_, class_5341[] p_80452_) {
            ArrayList list = Lists.newArrayList();
            if (p_80450_.has("enchantments")) {
                for (JsonElement jsonelement : class_3518.method_15261((JsonObject)p_80450_, (String)"enchantments")) {
                    String s = class_3518.method_15287((JsonElement)jsonelement, (String)"enchantment");
                    MobEnchant enchantment = (MobEnchant)ModRegistry.MOB_ENCHANT.method_10223(new class_2960(s));
                    list.add(enchantment);
                }
            }
            return new MobEnchantRandomlyFunction(p_80452_, list);
        }
    }
}

