/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.impl.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileNotFoundAction;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.collect.ImmutableMap;
import fuzs.forgeconfigapiport.impl.ForgeConfigAPIPort;
import fuzs.forgeconfigapiport.impl.core.CommonAbstractions;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;

public class ForgeConfigApiPortConfig {
    public static final ForgeConfigApiPortConfig INSTANCE;
    private static final String CONFIG_FILE_NAME = "forgeconfigapiport.toml";
    private static final Map<String, Object> CONFIG_VALUES;
    private static final ConfigSpec CONFIG_SPEC;
    private CommentedFileConfig configData;

    private ForgeConfigApiPortConfig() {
        this.loadFrom(CommonAbstractions.INSTANCE.getConfigDirectory().resolve(CONFIG_FILE_NAME));
    }

    private void loadFrom(Path configFile) {
        this.configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configFile, (ConfigFormat)TomlFormat.instance()).sync().onFileNotFound(FileNotFoundAction.copyData((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/forgeconfigapiport.toml")))).autosave().autoreload().writingMode(WritingMode.REPLACE).build();
        try {
            this.configData.load();
        }
        catch (ParsingException e) {
            throw new RuntimeException("Failed to load %s config from %s".formatted("Forge Config API Port", configFile), e);
        }
        if (!CONFIG_SPEC.isCorrect((Config)this.configData)) {
            ForgeConfigAPIPort.LOGGER.warn("Configuration file {} is not correct. Correcting", (Object)configFile);
            CONFIG_SPEC.correct((Config)this.configData, (action, path, incorrectValue, correctedValue) -> ForgeConfigAPIPort.LOGGER.warn("Incorrect key {} was corrected from {} to {}", new Object[]{path, incorrectValue, correctedValue}));
        }
        this.configData.save();
    }

    public <T> T getValue(String key) {
        if (!CONFIG_VALUES.containsKey(key)) {
            throw new IllegalArgumentException("%s is not a know config value key".formatted(key));
        }
        return (T)this.configData.getOptional(key).orElse(CONFIG_VALUES.get(key));
    }

    static {
        CONFIG_VALUES = ImmutableMap.builder().put((Object)"defaultConfigsPath", (Object)"defaultconfigs").put((Object)"forceGlobalServerConfigs", (Object)true).put((Object)"recreateConfigsWhenParsingFails", (Object)true).put((Object)"correctConfigValuesFromDefaultConfig", (Object)true).build();
        CONFIG_SPEC = new ConfigSpec();
        for (Map.Entry<String, Object> entry : CONFIG_VALUES.entrySet()) {
            CONFIG_SPEC.define(entry.getKey(), entry.getValue());
        }
        INSTANCE = new ForgeConfigApiPortConfig();
    }
}

