/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.capability;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.api.IEnchantCap;
import baguchan.enchantwithmob.capability.MobEnchantHandler;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.utils.MobEnchantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

public class MobEnchantCapability {
    private static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("6699a403-e2cc-31e6-195e-4757200e0935");
    private static final class_1322 HEALTH_MODIFIER = new class_1322(HEALTH_MODIFIER_UUID, "Health boost", 0.5, class_1322.class_1323.field_6330);
    private List<MobEnchantHandler> mobEnchants = Lists.newArrayList();
    private Optional<class_1309> enchantOwner = Optional.empty();
    private boolean fromOwner;
    private EnchantType enchantType = EnchantType.NORMAL;

    public void addMobEnchant(class_1309 entity, MobEnchant mobEnchant, int enchantLevel) {
        this.mobEnchants.add(new MobEnchantHandler(mobEnchant, enchantLevel));
        this.onNewEnchantEffect(entity, mobEnchant, enchantLevel);
        entity.method_18382();
        this.sync(entity);
    }

    public void addMobEnchant(class_1309 entity, MobEnchant mobEnchant, int enchantLevel, boolean ancient) {
        this.addMobEnchant(entity, mobEnchant, enchantLevel);
        this.setEnchantType(entity, ancient ? EnchantType.ANCIENT : EnchantType.NORMAL);
    }

    public void setEnchantType(class_1309 entity, EnchantType enchantType) {
        this.enchantType = enchantType;
        this.sync(entity);
    }

    public void addMobEnchantFromOwner(class_1309 entity, MobEnchant mobEnchant, int enchantLevel, class_1309 owner) {
        this.mobEnchants.add(new MobEnchantHandler(mobEnchant, enchantLevel));
        this.onNewEnchantEffect(entity, mobEnchant, enchantLevel);
        entity.method_18382();
        this.sync(entity);
    }

    public void addOwner(class_1309 entity, @Nullable class_1309 owner) {
        this.fromOwner = true;
        this.enchantOwner = Optional.ofNullable(owner);
        this.sync(entity);
    }

    public final void sync(class_1309 entity) {
        MobEnchantCapability capability = new MobEnchantCapability();
        capability.mobEnchants = this.mobEnchants;
        capability.enchantOwner = this.enchantOwner;
        capability.enchantType = this.enchantType;
        ((IEnchantCap)entity).setEnchantCap(capability);
    }

    public void removeOwner() {
        this.fromOwner = false;
        this.enchantOwner = Optional.empty();
    }

    public void removeAllMobEnchant(class_1309 entity) {
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            this.onRemoveEnchantEffect(entity, this.mobEnchants.get(i).getMobEnchant());
        }
        this.mobEnchants.removeAll(this.mobEnchants);
        entity.method_18382();
        this.sync(entity);
    }

    public void removeMobEnchantFromOwner(class_1309 entity) {
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            this.onRemoveEnchantEffect(entity, this.mobEnchants.get(i).getMobEnchant());
        }
        this.mobEnchants.removeAll(this.mobEnchants);
        this.removeOwner();
        entity.method_18382();
        this.sync(entity);
    }

    public void onNewEnchantEffect(class_1309 entity, MobEnchant enchant, int enchantLevel) {
        if (!entity.field_6002.field_9236) {
            class_1324 modifiableattributeinstance;
            enchant.applyAttributesModifiersToEntity(entity, entity.method_6127(), enchantLevel);
            if (((Boolean)EnchantConfig.COMMON.dungeonsLikeHealth.get()).booleanValue() && (modifiableattributeinstance = entity.method_6127().method_26842(class_5134.field_23716)) != null && !modifiableattributeinstance.method_6196(HEALTH_MODIFIER)) {
                modifiableattributeinstance.method_6202(HEALTH_MODIFIER);
                modifiableattributeinstance.method_26837(HEALTH_MODIFIER);
                entity.method_6033(entity.method_6032() * 1.25f);
            }
        }
    }

    protected void onChangedEnchantEffect(class_1309 entity, MobEnchant enchant, int enchantLevel) {
        if (!entity.field_6002.field_9236) {
            enchant.applyAttributesModifiersToEntity(entity, entity.method_6127(), enchantLevel);
        }
    }

    protected void onRemoveEnchantEffect(class_1309 entity, MobEnchant enchant) {
        if (!entity.field_6002.method_8608()) {
            enchant.removeAttributesModifiersFromEntity(entity, entity.method_6127());
            class_1324 modifiableattributeinstance = entity.method_6127().method_26842(class_5134.field_23716);
            if (modifiableattributeinstance != null && modifiableattributeinstance.method_6196(HEALTH_MODIFIER)) {
                entity.method_6033(entity.method_6032() / 1.25f);
                modifiableattributeinstance.method_6202(HEALTH_MODIFIER);
            }
        }
    }

    public List<MobEnchantHandler> getMobEnchants() {
        return this.mobEnchants;
    }

    public boolean hasEnchant() {
        return !this.mobEnchants.isEmpty();
    }

    public Optional<class_1309> getEnchantOwner() {
        return this.enchantOwner;
    }

    public boolean hasOwner() {
        return this.enchantOwner.isPresent() && this.enchantOwner.get().method_5805();
    }

    public boolean isFromOwner() {
        return this.fromOwner;
    }

    public EnchantType getEnchantType() {
        return this.enchantType;
    }

    public boolean isAncient() {
        return this.enchantType == EnchantType.ANCIENT;
    }

    public class_2487 serializeNBT() {
        class_2487 nbt = new class_2487();
        class_2499 listnbt = new class_2499();
        for (int i = 0; i < this.mobEnchants.size(); ++i) {
            listnbt.add((Object)this.mobEnchants.get(i).writeNBT());
        }
        nbt.method_10566("StoredMobEnchants", (class_2520)listnbt);
        nbt.method_10556("FromOwner", this.fromOwner);
        nbt.method_10582("EnchantType", this.enchantType.name());
        return nbt;
    }

    public void deserializeNBT(class_2487 nbt) {
        class_2499 list = MobEnchantUtils.getEnchantmentListForNBT(nbt);
        this.mobEnchants.clear();
        for (int i = 0; i < list.size(); ++i) {
            class_2487 compoundnbt = list.method_10602(i);
            MobEnchant mobEnchant = MobEnchantUtils.getEnchantFromNBT(compoundnbt);
            if (mobEnchant == null) continue;
            this.mobEnchants.add(new MobEnchantHandler(mobEnchant, MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt)));
        }
        this.fromOwner = nbt.method_10577("FromOwner");
        this.enchantType = EnchantType.get(nbt.method_10558("EnchantType"));
    }

    public static enum EnchantType {
        NORMAL,
        ANCIENT;


        public static EnchantType get(String nameIn) {
            for (EnchantType enchantType : EnchantType.values()) {
                if (!enchantType.name().equals(nameIn)) continue;
                return enchantType;
            }
            return NORMAL;
        }
    }
}

