/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.mobenchant;

import baguchan.enchantwithmob.EnchantConfig;
import baguchan.enchantwithmob.registry.ModRegistry;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_5131;

public class MobEnchant {
    private final Map<class_1320, class_1322> attributeModifierMap = Maps.newHashMap();
    protected final Rarity enchantType;
    private final int level;
    private int minlevel = 1;

    public MobEnchant(Properties properties) {
        this.enchantType = properties.enchantType;
        this.level = properties.level;
    }

    public Rarity getRarity() {
        return this.enchantType;
    }

    public MobEnchant setMinLevel(int level) {
        this.minlevel = level;
        return this;
    }

    public int getMinLevel() {
        return this.minlevel;
    }

    public int getMaxLevel() {
        return this.level;
    }

    public int getMinEnchantability(int enchantmentLevel) {
        return 1 + enchantmentLevel * 10;
    }

    public int getMaxEnchantability(int enchantmentLevel) {
        return this.getMinEnchantability(enchantmentLevel) + 5;
    }

    public void tick(class_1309 entity, int level) {
    }

    public final boolean isCompatibleWith(MobEnchant enchantmentIn) {
        return this.canApplyTogether(enchantmentIn) && enchantmentIn.canApplyTogether(this);
    }

    public boolean isTresureEnchant() {
        return false;
    }

    public boolean isOnlyChest() {
        return false;
    }

    public boolean isCompatibleMob(class_1309 livingEntity) {
        return true;
    }

    protected boolean canApplyTogether(MobEnchant ench) {
        return this != ench;
    }

    public MobEnchant addAttributesModifier(class_1320 attributeIn, String uuid, double amount, class_1322.class_1323 operation) {
        class_1322 attributemodifier = new class_1322(UUID.fromString(uuid), class_156.method_646((String)"mobenchant", (class_2960)ModRegistry.MOB_ENCHANT.method_10221((Object)this)), amount, operation);
        this.attributeModifierMap.put(attributeIn, attributemodifier);
        return this;
    }

    public Map<class_1320, class_1322> getAttributeModifierMap() {
        return this.attributeModifierMap;
    }

    public void removeAttributesModifiersFromEntity(class_1309 entityLivingBaseIn, class_5131 attributeMapIn) {
        for (Map.Entry<class_1320, class_1322> entry : this.attributeModifierMap.entrySet()) {
            class_1324 modifiableattributeinstance = attributeMapIn.method_26842(entry.getKey());
            if (modifiableattributeinstance == null) continue;
            modifiableattributeinstance.method_6202(entry.getValue());
        }
    }

    public void applyAttributesModifiersToEntity(class_1309 entityLivingBaseIn, class_5131 attributeMapIn, int amplifier) {
        for (Map.Entry<class_1320, class_1322> entry : this.attributeModifierMap.entrySet()) {
            class_1324 modifiableattributeinstance = attributeMapIn.method_26842(entry.getKey());
            if (modifiableattributeinstance == null) continue;
            class_1322 attributemodifier = entry.getValue();
            modifiableattributeinstance.method_6202(attributemodifier);
            modifiableattributeinstance.method_26837(new class_1322(attributemodifier.method_6189(), ModRegistry.MOB_ENCHANT.method_10221((Object)this).toString() + " " + amplifier, this.getAttributeModifierAmount(amplifier, attributemodifier), attributemodifier.method_6182()));
        }
    }

    public double getAttributeModifierAmount(int amplifier, class_1322 modifier) {
        return modifier.method_6186() * (double)amplifier;
    }

    public boolean isDisabled() {
        return ((List)EnchantConfig.COMMON.DISABLE_ENCHANTS.get()).contains(ModRegistry.MOB_ENCHANT.method_10221((Object)this).toString());
    }

    public static class Properties {
        private final Rarity enchantType;
        private final int level;

        public Properties(Rarity enchantType, int level) {
            this.enchantType = enchantType;
            this.level = level;
        }
    }

    public static enum Rarity {
        COMMON(10),
        UNCOMMON(5),
        RARE(2),
        VERY_RARE(1);

        private final int weight;

        private Rarity(int rarityWeight) {
            this.weight = rarityWeight;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

