/*
 * Decompiled with CFR 0.152.
 */
package baguchan.enchantwithmob.utils;

import baguchan.enchantwithmob.capability.MobEnchantCapability;
import baguchan.enchantwithmob.capability.MobEnchantHandler;
import baguchan.enchantwithmob.mobenchant.MobEnchant;
import baguchan.enchantwithmob.registry.ModItems;
import baguchan.enchantwithmob.registry.ModRegistry;
import baguchan.enchantwithmob.utils.MobEnchantmentData;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_6011;

public class MobEnchantUtils {
    public static final String TAG_MOBENCHANT = "MobEnchant";
    public static final String TAG_ENCHANT_LEVEL = "EnchantLevel";
    public static final String TAG_STORED_MOBENCHANTS = "StoredMobEnchants";

    @Nullable
    public static MobEnchant getEnchantFromNBT(@Nullable class_2487 tag) {
        if (tag != null && ModRegistry.MOB_ENCHANT.method_10250(class_2960.method_12829((String)tag.method_10558(TAG_MOBENCHANT)))) {
            return (MobEnchant)ModRegistry.MOB_ENCHANT.method_10223(class_2960.method_12829((String)tag.method_10558(TAG_MOBENCHANT)));
        }
        return null;
    }

    public static int getEnchantLevelFromNBT(@Nullable class_2487 tag) {
        if (tag != null) {
            return tag.method_10550(TAG_ENCHANT_LEVEL);
        }
        return 0;
    }

    @Nullable
    public static MobEnchant getEnchantFromString(@Nullable String id) {
        if (id != null && ModRegistry.MOB_ENCHANT.method_10250(class_2960.method_12829((String)id))) {
            return (MobEnchant)ModRegistry.MOB_ENCHANT.method_10223(class_2960.method_12829((String)id));
        }
        return null;
    }

    @Nullable
    public static MobEnchant getEnchantFromResourceLocation(@Nullable class_2960 id) {
        if (id != null && ModRegistry.MOB_ENCHANT.method_10250(id)) {
            return (MobEnchant)ModRegistry.MOB_ENCHANT.method_10223(id);
        }
        return null;
    }

    public static boolean hasMobEnchant(class_1799 stack) {
        class_2487 compoundnbt = stack.method_7969();
        return compoundnbt != null && compoundnbt.method_10545(TAG_STORED_MOBENCHANTS);
    }

    public static class_2499 getEnchantmentListForNBT(class_2487 compoundnbt) {
        return compoundnbt != null ? compoundnbt.method_10554(TAG_STORED_MOBENCHANTS, 10) : new class_2499();
    }

    public static Map<MobEnchant, Integer> getEnchantments(class_1799 stack) {
        class_2499 listnbt = MobEnchantUtils.getEnchantmentListForNBT(stack.method_7969());
        return MobEnchantUtils.makeMobEnchantListFromListNBT(listnbt);
    }

    public static void setEnchantments(Map<MobEnchant, Integer> enchMap, class_1799 stack) {
        class_2499 listnbt = new class_2499();
        for (Map.Entry<MobEnchant, Integer> entry : enchMap.entrySet()) {
            MobEnchant enchantment = entry.getKey();
            if (enchantment == null) continue;
            int i = entry.getValue();
            class_2487 compoundnbt = new class_2487();
            compoundnbt.method_10582(TAG_MOBENCHANT, String.valueOf(ModRegistry.MOB_ENCHANT.method_10221((Object)enchantment)));
            compoundnbt.method_10575(TAG_ENCHANT_LEVEL, (short)i);
            listnbt.add((Object)compoundnbt);
            if (stack.method_7909() != ModItems.MOB_ENCHANT_BOOK) continue;
            MobEnchantUtils.addMobEnchantToItemStack(stack, enchantment, i);
        }
        if (listnbt.isEmpty()) {
            stack.method_7983(TAG_STORED_MOBENCHANTS);
        }
    }

    private static Map<MobEnchant, Integer> makeMobEnchantListFromListNBT(class_2499 p_226652_0_) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (int i = 0; i < p_226652_0_.size(); ++i) {
            class_2487 compoundnbt = p_226652_0_.method_10602(i);
            MobEnchant mobEnchant = MobEnchantUtils.getEnchantFromString(compoundnbt.method_10558(TAG_MOBENCHANT));
            map.put(mobEnchant, compoundnbt.method_10550(TAG_ENCHANT_LEVEL));
        }
        return map;
    }

    public static void addMobEnchantToItemStack(class_1799 itemIn, MobEnchant mobenchant, int level) {
        class_2499 listnbt = MobEnchantUtils.getEnchantmentListForNBT(itemIn.method_7969());
        boolean flag = true;
        class_2960 resourcelocation = ModRegistry.MOB_ENCHANT.method_10221((Object)mobenchant);
        for (int i = 0; i < listnbt.size(); ++i) {
            class_2487 compoundnbt = listnbt.method_10602(i);
            class_2960 resourcelocation1 = class_2960.method_12829((String)compoundnbt.method_10558(TAG_MOBENCHANT));
            if (resourcelocation1 == null || !resourcelocation1.equals((Object)resourcelocation)) continue;
            if (compoundnbt.method_10550(TAG_ENCHANT_LEVEL) < level) {
                compoundnbt.method_10569(TAG_ENCHANT_LEVEL, level);
            }
            flag = false;
            break;
        }
        if (flag) {
            class_2487 compoundnbt1 = new class_2487();
            compoundnbt1.method_10582(TAG_MOBENCHANT, String.valueOf(resourcelocation));
            compoundnbt1.method_10569(TAG_ENCHANT_LEVEL, level);
            listnbt.add((Object)compoundnbt1);
        }
        itemIn.method_7969().method_10566(TAG_STORED_MOBENCHANTS, (class_2520)listnbt);
    }

    public static boolean addItemMobEnchantToEntity(class_1799 itemIn, class_1309 entity, MobEnchantCapability capability) {
        class_2499 listnbt = MobEnchantUtils.getEnchantmentListForNBT(itemIn.method_7969());
        boolean flag = false;
        for (int i = 0; i < listnbt.size(); ++i) {
            class_2487 compoundnbt = listnbt.method_10602(i);
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(MobEnchantUtils.getEnchantFromNBT(compoundnbt), entity, capability)) continue;
            capability.addMobEnchant(entity, MobEnchantUtils.getEnchantFromNBT(compoundnbt), MobEnchantUtils.getEnchantLevelFromNBT(compoundnbt));
            flag = true;
        }
        return flag;
    }

    public static void removeMobEnchantToEntity(class_1309 entity, MobEnchantCapability capability) {
        capability.removeAllMobEnchant(entity);
    }

    public static int getExperienceFromMob(MobEnchantCapability cap) {
        int l = 0;
        for (MobEnchantHandler list : cap.getMobEnchants()) {
            MobEnchant enchantment = list.getMobEnchant();
            int integer = list.getEnchantLevel();
            l += enchantment.getMinEnchantability(integer);
        }
        return l;
    }

    public static boolean addRandomEnchantmentToEntity(class_1309 livingEntity, MobEnchantCapability capability, class_5819 random, int level, boolean allowRare) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowRare);
        boolean flag = false;
        for (MobEnchantmentData enchantmentdata : list) {
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(enchantmentdata.enchantment, livingEntity, capability)) continue;
            capability.addMobEnchant(livingEntity, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel);
            flag = true;
        }
        return flag;
    }

    public static boolean addUnstableRandomEnchantmentToEntity(class_1309 livingEntity, class_1309 ownerEntity, MobEnchantCapability capability, class_5819 random, int level, boolean allowRare) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowRare);
        boolean flag = false;
        for (MobEnchantmentData enchantmentdata : list) {
            if (!MobEnchantUtils.checkAllowMobEnchantFromMob(enchantmentdata.enchantment, livingEntity, capability)) continue;
            capability.addMobEnchantFromOwner(livingEntity, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel, ownerEntity);
            flag = true;
        }
        if (flag) {
            capability.addOwner(livingEntity, ownerEntity);
        }
        return flag;
    }

    public static class_1799 addRandomEnchantmentToItemStack(class_5819 random, class_1799 stack, int level, boolean allowRare) {
        List<MobEnchantmentData> list = MobEnchantUtils.buildEnchantmentList(random, level, allowRare);
        for (MobEnchantmentData enchantmentdata : list) {
            MobEnchantUtils.addMobEnchantToItemStack(stack, enchantmentdata.enchantment, enchantmentdata.enchantmentLevel);
        }
        return stack;
    }

    public static boolean findMobEnchantHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (!mobEnchant.getMobEnchant().equals(findMobEnchant)) continue;
            return true;
        }
        return false;
    }

    public static boolean findMobEnchant(List<MobEnchant> list, MobEnchant findMobEnchant) {
        return list.contains(findMobEnchant);
    }

    public static boolean findMobEnchantFromHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (mobEnchant == null || !mobEnchant.getMobEnchant().equals(findMobEnchant)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAllowMobEnchantFromMob(@Nullable MobEnchant mobEnchant, class_1309 livingEntity, MobEnchantCapability capability) {
        if (mobEnchant != null && !mobEnchant.isCompatibleMob(livingEntity)) {
            return false;
        }
        for (MobEnchantHandler enchantHandler : capability.getMobEnchants()) {
            if (mobEnchant == null || enchantHandler.getMobEnchant() == null || enchantHandler.getMobEnchant().isCompatibleWith(mobEnchant)) continue;
            return false;
        }
        return mobEnchant != null;
    }

    public static int getMobEnchantLevelFromHandler(List<MobEnchantHandler> list, MobEnchant findMobEnchant) {
        for (MobEnchantHandler mobEnchant : list) {
            if (mobEnchant == null || !mobEnchant.getMobEnchant().equals(findMobEnchant)) continue;
            return mobEnchant.getEnchantLevel();
        }
        return 0;
    }

    public static List<MobEnchantmentData> buildEnchantmentList(class_5819 randomIn, int level, boolean allowTresure) {
        ArrayList list = Lists.newArrayList();
        int i = 1;
        if (i <= 0) {
            return list;
        }
        level = level + 1 + randomIn.method_43048(i / 4 + 1) + randomIn.method_43048(i / 4 + 1);
        float f = (randomIn.method_43057() + randomIn.method_43057() - 1.0f) * 0.15f;
        List<MobEnchantmentData> list1 = MobEnchantUtils.makeMobEnchantmentDatas(level = class_3532.method_15340((int)Math.round((float)level + (float)level * f), (int)1, (int)Integer.MAX_VALUE), allowTresure);
        if (!list1.isEmpty()) {
            class_6011.method_34986((class_5819)randomIn, list1).ifPresent(list::add);
            while (randomIn.method_43048(50) <= level) {
                if (!list.isEmpty()) {
                    MobEnchantUtils.removeIncompatible(list1, (MobEnchantmentData)((Object)class_156.method_20793((List)list)));
                }
                if (list1.isEmpty()) break;
                class_6011.method_34986((class_5819)randomIn, list1).ifPresent(list::add);
                level /= 2;
            }
        }
        return list;
    }

    public static List<MobEnchantmentData> makeMobEnchantmentDatas(int p_185291_0_, boolean allowTresure) {
        ArrayList list = Lists.newArrayList();
        block0: for (MobEnchant enchantment : ModRegistry.MOB_ENCHANT.method_10220().toList()) {
            if (enchantment.isTresureEnchant() && !allowTresure || enchantment.isOnlyChest()) continue;
            for (int i = enchantment.getMaxLevel(); i > enchantment.getMinLevel() - 1; --i) {
                if (p_185291_0_ < enchantment.getMinEnchantability(i) || p_185291_0_ > enchantment.getMaxEnchantability(i)) continue;
                list.add(new MobEnchantmentData(enchantment, i));
                continue block0;
            }
        }
        return list;
    }

    private static void removeIncompatible(List<MobEnchantmentData> dataList, MobEnchantmentData data) {
        Iterator<MobEnchantmentData> iterator = dataList.iterator();
        while (iterator.hasNext()) {
            if (data.enchantment.isCompatibleWith(iterator.next().enchantment)) continue;
            iterator.remove();
        }
    }
}

