/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob;

import com.baguchan.enchantwithmob.EnchantConfig;
import com.baguchan.enchantwithmob.EnchantWithMob;
import com.baguchan.enchantwithmob.capability.MobEnchantCapability;
import com.baguchan.enchantwithmob.message.EnchantedMessage;
import com.baguchan.enchantwithmob.registry.MobEnchants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="enchantwithmob")
public class CommonEventHandler {
    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity && !(event.getObject() instanceof PlayerEntity)) {
            event.addCapability(new ResourceLocation("enchantwithmob", "mob_enchant"), (ICapabilityProvider)new MobEnchantCapability());
        }
    }

    @SubscribeEvent
    public static void onSpawnEntity(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntity() instanceof LivingEntity && ((Boolean)EnchantConfig.COMMON.naturalSpawnEnchantedMob.get()).booleanValue()) {
            LivingEntity livingEntity = (LivingEntity)event.getEntity();
            IWorld world = event.getWorld();
            if (event.getSpawnReason() != SpawnReason.BREEDING && event.getSpawnReason() != SpawnReason.CONVERSION && event.getSpawnReason() != SpawnReason.STRUCTURE && event.getSpawnReason() != SpawnReason.MOB_SUMMONED && world.func_201674_k().nextFloat() < 0.01f + world.func_175649_E(livingEntity.func_180425_c()).func_180170_c() * 0.1f && !world.func_201670_d()) {
                livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> cap.setMobEnchant(livingEntity, MobEnchants.byId(MobEnchants.getRegistry().getValues().size())));
            }
        }
    }

    @SubscribeEvent
    public static void onUpdateEnchanted(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity.func_130014_f_().func_82737_E() % 80L == 0L && !livingEntity.field_70170_p.field_72995_K) {
            livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                if (cap.hasEnchant()) {
                    EnchantedMessage message = new EnchantedMessage((Entity)livingEntity, cap.getMobEnchant());
                    EnchantWithMob.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> livingEntity), (Object)message);
                }
            });
        }
    }

    @SubscribeEvent
    public void onEntityHurt(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        livingEntity.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
            if (cap.hasEnchant() && cap.getMobEnchant() == MobEnchants.PROTECTION) {
                event.setAmount(event.getAmount() * 0.75f);
            }
        });
        if (event.getSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity attaker = (LivingEntity)event.getSource().func_76346_g();
            attaker.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
                if (cap.hasEnchant() && cap.getMobEnchant() == MobEnchants.STRONG) {
                    event.setAmount(event.getAmount() * 1.25f);
                }
            });
        }
    }
}

