/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.registry;

import com.baguchan.enchantwithmob.mobenchant.MobEnchant;
import com.baguchan.enchantwithmob.mobenchant.ProtectionMobEnchant;
import com.baguchan.enchantwithmob.mobenchant.SpeedyMobEnchant;
import com.baguchan.enchantwithmob.mobenchant.StrongMobEnchant;
import com.baguchan.enchantwithmob.mobenchant.ThronEnchant;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="enchantwithmob", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MobEnchants {
    public static final MobEnchant PROTECTION = new ProtectionMobEnchant(new MobEnchant.Properties(MobEnchant.Rarity.COMMON, 4));
    public static final MobEnchant SPEEDY = new SpeedyMobEnchant(new MobEnchant.Properties(MobEnchant.Rarity.RARE, 2)).addAttributesModifier(Attributes.field_233821_d_, "91AEAA56-376B-4498-935B-2F7F68070635", 0.05f, AttributeModifier.Operation.ADDITION);
    public static final MobEnchant STRONG = new StrongMobEnchant(new MobEnchant.Properties(MobEnchant.Rarity.COMMON, 3));
    public static final MobEnchant THORN = new ThronEnchant(new MobEnchant.Properties(MobEnchant.Rarity.VERY_RARE, 3));
    public static final MobEnchant HEALTH_BOOST = new ThronEnchant(new MobEnchant.Properties(MobEnchant.Rarity.VERY_RARE, 3)).addAttributesModifier(Attributes.field_233818_a_, "5D6F0BA2-1186-46AC-B896-C61C5CEE99CC", 2.0, AttributeModifier.Operation.ADDITION);
    private static ForgeRegistry<MobEnchant> registry;

    @SubscribeEvent
    public static void onNewRegistry(RegistryEvent.NewRegistry event) {
        registry = (ForgeRegistry)new RegistryBuilder().setType(MobEnchant.class).setName(new ResourceLocation("enchantwithmob", "mob_enchant")).setDefaultKey(new ResourceLocation("enchantwithmob", "protection")).create();
    }

    @SubscribeEvent
    public static void onRegisterEnchant(RegistryEvent.Register<MobEnchant> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new MobEnchant[]{(MobEnchant)PROTECTION.setRegistryName("protection"), (MobEnchant)SPEEDY.setRegistryName("speedy"), (MobEnchant)STRONG.setRegistryName("strong"), (MobEnchant)THORN.setRegistryName("thorn"), (MobEnchant)HEALTH_BOOST.setRegistryName("health_boost")});
    }

    public static ForgeRegistry<MobEnchant> getRegistry() {
        if (registry == null) {
            throw new IllegalStateException("Registry not yet initialized");
        }
        return registry;
    }

    public static int getId(MobEnchant enchant) {
        return registry.getID((IForgeRegistryEntry)enchant);
    }

    public static MobEnchant byId(int id) {
        return (MobEnchant)registry.getValue(id);
    }
}

