/*
 * Decompiled with CFR 0.152.
 */
package com.baguchan.enchantwithmob.client.render.layer;

import com.baguchan.enchantwithmob.EnchantWithMob;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EnchantLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private static final ResourceLocation ENCHANT_TEXTURE = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    protected static final RenderState.TransparencyState ADDITIVE_TRANSPARENCY = new RenderState.TransparencyState("additive_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderState.DiffuseLightingState DIFFUSE_LIGHTING_ENABLED = new RenderState.DiffuseLightingState(true);
    protected static final RenderState.FogState BLACK_FOG = new RenderState.FogState("black_fog", () -> {
        RenderSystem.fog((int)2918, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.enableFog();
    }, () -> {
        FogRenderer.func_228373_b_();
        RenderSystem.disableFog();
    });
    protected static final RenderState.AlphaState DEFAULT_ALPHA = new RenderState.AlphaState(0.003921569f);
    protected static final RenderState.OverlayState OVERLAY_ENABLED = new RenderState.OverlayState(true);
    protected static final RenderState.CullState CULL_DISABLED = new RenderState.CullState(false);

    public EnchantLayer(IEntityRenderer<T, M> p_i50947_1_) {
        super(p_i50947_1_);
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        entitylivingbaseIn.getCapability(EnchantWithMob.MOB_ENCHANT_CAP).ifPresent(cap -> {
            if (cap.hasEnchant() && !entitylivingbaseIn.func_82150_aj()) {
                float f = (float)entitylivingbaseIn.field_70173_aa + partialTicks;
                EntityModel<T> entitymodel = this.func_225635_b_();
                entitymodel.func_212843_a_((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
                this.func_215332_c().func_217111_a(entitymodel);
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(EnchantLayer.getEnergyLight(this.func_225633_a_(), this.func_225634_a_(f), f * 0.01f));
                entitymodel.func_225597_a_((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                entitymodel.func_225598_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, 0.5f, 0.5f, 0.5f, 1.0f);
            }
        });
    }

    public static RenderType getEnergyLight(ResourceLocation locationIn, float uIn, float vIn) {
        return RenderType.func_228633_a_((String)"energy_light", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(locationIn, false, false)).func_228725_a_((RenderState.TexturingState)new RenderState.OffsetTexturingState(uIn, vIn)).func_228717_a_(BLACK_FOG).func_228726_a_(ADDITIVE_TRANSPARENCY).func_228716_a_(DIFFUSE_LIGHTING_ENABLED).func_228713_a_(DEFAULT_ALPHA).func_228714_a_(CULL_DISABLED).func_228722_a_(OVERLAY_ENABLED).func_228728_a_(false));
    }

    protected float func_225634_a_(float p_225634_1_) {
        return p_225634_1_ * 0.01f;
    }

    protected ResourceLocation func_225633_a_() {
        return ENCHANT_TEXTURE;
    }

    protected EntityModel<T> func_225635_b_() {
        return this.func_215332_c();
    }
}

