/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.blockentity;

import com.the_millman.farmingutils.common.blocks.CocoaFarmerBlock;
import com.the_millman.farmingutils.core.init.BlockEntityInit;
import com.the_millman.farmingutils.core.init.ItemInit;
import com.the_millman.farmingutils.core.tags.ModItemTags;
import com.the_millman.farmingutils.core.util.FarmingConfig;
import com.the_millman.themillmanlib.common.blockentity.ItemEnergyBlockEntity;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;

public class CocoaFarmerBE
extends ItemEnergyBlockEntity {
    private int x;
    private int y;
    private int z;
    private int tick;
    int pX;
    int pY;
    int pZ;
    boolean initialized = false;
    int range;
    BlockPos facingPos = null;
    boolean needRedstone = false;
    boolean pickupDrops = true;

    public CocoaFarmerBE(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.COCOA_BEANS_FARMER.get(), pWorldPosition, pBlockState);
    }

    protected void init() {
        this.initialized = true;
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CocoaFarmerBlock.f_54117_);
        if (facing == Direction.NORTH) {
            this.x = this.m_58899_().m_123341_();
            this.z = this.m_58899_().m_123343_() - 2;
        } else if (facing == Direction.SOUTH) {
            this.x = this.m_58899_().m_123341_();
            this.z = this.m_58899_().m_123343_() + 2;
        } else if (facing == Direction.WEST) {
            this.x = this.m_58899_().m_123341_() - 2;
            this.z = this.m_58899_().m_123343_();
        } else if (facing == Direction.EAST) {
            this.x = this.m_58899_().m_123341_() + 2;
            this.z = this.m_58899_().m_123343_();
        }
        this.y = this.m_58899_().m_123342_();
        this.tick = 0;
        this.pX = 0;
        this.pY = 0;
        this.pZ = 0;
        this.range = 1;
        this.facingPos = this.m_58899_();
        this.needRedstone = false;
        this.pickupDrops = true;
    }

    public void tickServer() {
        if (!this.initialized) {
            this.init();
        }
        if (this.hasPowerToWork((Integer)FarmingConfig.COCOA_BEANS_FARMER_USEPERTICK.get())) {
            ++this.tick;
            if (this.tick == (Integer)FarmingConfig.COCOA_BEANS_FARMER_TICK.get()) {
                this.tick = 0;
                this.redstoneUpgrade();
                if (this.canWork()) {
                    this.upgradeSlot();
                    BlockPos posToBreak = new BlockPos(this.x + this.pX, this.y + this.pY, this.z + this.pZ);
                    this.destroyBlock(posToBreak, false);
                    this.placeBlock(posToBreak);
                    this.m_6596_();
                    this.stadioState();
                }
            }
        }
    }

    private void upgradeSlot() {
        this.rangeUpgrade();
        this.dropUpgrade();
    }

    private void stadioState() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CocoaFarmerBlock.f_54117_);
        if (facing == Direction.NORTH) {
            ++this.pY;
            if (this.pY == 5) {
                this.pY = 0;
                ++this.pX;
                if (this.pX >= this.range) {
                    this.pX = 0;
                    this.pY = 0;
                }
            }
        } else if (facing == Direction.SOUTH) {
            ++this.pY;
            if (this.pY == 5) {
                this.pY = 0;
                --this.pX;
                if (this.pX <= -this.range) {
                    this.pX = 0;
                    this.pY = 0;
                }
            }
        } else if (facing == Direction.WEST) {
            ++this.pY;
            if (this.pY == 5) {
                this.pY = 0;
                --this.pZ;
                if (this.pZ <= -this.range) {
                    this.pZ = 0;
                    this.pY = 0;
                }
            }
        } else if (facing == Direction.EAST) {
            ++this.pY;
            if (this.pY == 5) {
                this.pY = 0;
                ++this.pZ;
                if (this.pZ >= this.range) {
                    this.pZ = 0;
                    this.pY = 0;
                }
            }
        }
    }

    private boolean canWork() {
        if (this.needRedstone) {
            return (Boolean)this.m_58900_().m_61143_((Property)CocoaFarmerBlock.POWERED) != false;
        }
        if (!this.needRedstone) {
            return true;
        }
        return true;
    }

    private void rangeUpgrade() {
        ItemStack upgradeSlot = this.itemStorage.getStackInSlot(9);
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CocoaFarmerBlock.f_54117_);
        if (upgradeSlot.m_150930_((Item)ItemInit.IRON_UPGRADE.get())) {
            if (facing == Direction.NORTH) {
                this.x = this.m_58899_().m_123341_() - 1;
                this.z = this.m_58899_().m_123343_() - 2;
                this.range = 3;
            } else if (facing == Direction.SOUTH) {
                this.x = this.m_58899_().m_123341_() + 1;
                this.z = this.m_58899_().m_123343_() + 2;
                this.range = 3;
            } else if (facing == Direction.WEST) {
                this.x = this.m_58899_().m_123341_() - 2;
                this.z = this.m_58899_().m_123343_() + 1;
                this.range = 3;
            } else if (facing == Direction.EAST) {
                this.x = this.m_58899_().m_123341_() + 2;
                this.z = this.m_58899_().m_123343_() - 1;
                this.range = 3;
            }
        } else if (upgradeSlot.m_150930_((Item)ItemInit.GOLD_UPGRADE.get())) {
            if (facing == Direction.NORTH) {
                this.x = this.m_58899_().m_123341_() - 2;
                this.z = this.m_58899_().m_123343_() - 2;
                this.range = 5;
            } else if (facing == Direction.SOUTH) {
                this.x = this.m_58899_().m_123341_() + 2;
                this.z = this.m_58899_().m_123343_() + 2;
                this.range = 5;
            } else if (facing == Direction.WEST) {
                this.x = this.m_58899_().m_123341_() - 2;
                this.z = this.m_58899_().m_123343_() + 2;
                this.range = 5;
            } else if (facing == Direction.EAST) {
                this.x = this.m_58899_().m_123341_() + 2;
                this.z = this.m_58899_().m_123343_() - 2;
                this.range = 5;
            }
        } else if (upgradeSlot.m_150930_((Item)ItemInit.DIAMOND_UPGRADE.get())) {
            if (facing == Direction.NORTH) {
                this.x = this.m_58899_().m_123341_() - 3;
                this.z = this.m_58899_().m_123343_() - 2;
                this.range = 7;
            } else if (facing == Direction.SOUTH) {
                this.x = this.m_58899_().m_123341_() + 3;
                this.z = this.m_58899_().m_123343_() + 2;
                this.range = 7;
            } else if (facing == Direction.WEST) {
                this.x = this.m_58899_().m_123341_() - 2;
                this.z = this.m_58899_().m_123343_() + 3;
                this.range = 7;
            } else if (facing == Direction.EAST) {
                this.x = this.m_58899_().m_123341_() + 2;
                this.z = this.m_58899_().m_123343_() - 3;
                this.range = 7;
            }
        } else if (upgradeSlot.m_41619_()) {
            if (facing == Direction.NORTH) {
                this.x = this.m_58899_().m_123341_();
                this.z = this.m_58899_().m_123343_() - 2;
                this.range = 1;
            } else if (facing == Direction.SOUTH) {
                this.x = this.m_58899_().m_123341_();
                this.z = this.m_58899_().m_123343_() + 2;
                this.range = 1;
            } else if (facing == Direction.WEST) {
                this.x = this.m_58899_().m_123341_() - 2;
                this.z = this.m_58899_().m_123343_();
                this.range = 1;
            } else if (facing == Direction.EAST) {
                this.x = this.m_58899_().m_123341_() + 2;
                this.z = this.m_58899_().m_123343_();
                this.range = 1;
            }
        }
    }

    private void redstoneUpgrade() {
        ItemStack upgradeSlot = this.itemStorage.getStackInSlot(10);
        if (upgradeSlot.m_150930_((Item)ItemInit.REDSTONE_UPGRADE.get())) {
            this.needRedstone = true;
        } else if (!upgradeSlot.m_150930_((Item)ItemInit.REDSTONE_UPGRADE.get())) {
            this.needRedstone = false;
        }
    }

    private void dropUpgrade() {
        ItemStack upgradeSlot = this.itemStorage.getStackInSlot(11);
        if (upgradeSlot.m_150930_((Item)ItemInit.DROP_UPGRADE.get())) {
            this.pickupDrops = false;
        } else if (!upgradeSlot.m_150930_((Item)ItemInit.DROP_UPGRADE.get())) {
            this.pickupDrops = true;
        }
    }

    private boolean destroyBlock(BlockPos pos, boolean dropBlock) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        if (this.getDestBlock(state)) {
            if (!this.f_58857_.f_46443_) {
                if (this.pickupDrops) {
                    this.collectDrops(pos, 0, 9);
                    this.f_58857_.m_46961_(pos, dropBlock);
                    this.energyStorage.consumeEnergy(((Integer)FarmingConfig.COCOA_BEANS_FARMER_USEPERTICK.get()).intValue());
                    return true;
                }
                if (!this.pickupDrops) {
                    this.f_58857_.m_46961_(pos, true);
                    this.energyStorage.consumeEnergy(((Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get()).intValue());
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean placeBlock(BlockPos pos) {
        Item item;
        Direction facing;
        int slot = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.itemStorage.getStackInSlot(i).m_41619_() || this.itemStorage.getStackInSlot(i).m_41619_()) continue;
            slot = i;
            break;
        }
        if ((facing = (Direction)this.m_58900_().m_61143_((Property)CocoaFarmerBlock.f_54117_)) == Direction.NORTH) {
            this.facingPos = pos.m_5484_(Direction.NORTH, 1);
        } else if (facing == Direction.SOUTH) {
            this.facingPos = pos.m_5484_(Direction.SOUTH, 1);
        } else if (facing == Direction.WEST) {
            this.facingPos = pos.m_5484_(Direction.WEST, 1);
        } else if (facing == Direction.EAST) {
            this.facingPos = pos.m_5484_(Direction.EAST, 1);
        }
        BlockState state = this.f_58857_.m_8055_(pos);
        BlockState facingState = this.f_58857_.m_8055_(this.facingPos);
        if (state.m_60734_() == Blocks.f_50262_) {
            return false;
        }
        if (facingState.m_60713_(Blocks.f_50002_) && (item = this.itemStorage.getStackInSlot(slot).m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (!this.f_58857_.f_46443_ && blockItem.m_5456_() == Items.f_42533_) {
                Block block = blockItem.m_40614_();
                this.f_58857_.m_7731_(pos, (BlockState)block.m_49966_().m_61124_((Property)CocoaBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)CocoaFarmerBlock.f_54117_))), 3);
                this.f_58857_.m_5594_(null, pos, SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ItemStack stack = this.itemStorage.getStackInSlot(slot);
                stack.m_41774_(1);
                this.energyStorage.consumeEnergy(((Integer)FarmingConfig.COCOA_BEANS_FARMER_USEPERTICK.get()).intValue());
            }
        }
        return false;
    }

    private boolean getDestBlock(BlockState state) {
        return state.m_60734_() == Blocks.f_50262_ && (Integer)state.m_61143_((Property)BlockStateProperties.f_61406_) == 2;
    }

    protected ItemStackHandler itemStorage() {
        return new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                CocoaFarmerBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot < 9) {
                    if (stack.m_41720_() == Items.f_42533_) {
                        return true;
                    }
                } else if (slot >= 9 && CocoaFarmerBE.this.isValidUpgrade(stack)) {
                    if (slot == 9) {
                        return stack.m_150922_(ModItemTags.RANGE_UPGRADES);
                    }
                    if (slot == 10) {
                        return stack.m_150930_((Item)ItemInit.REDSTONE_UPGRADE.get());
                    }
                    return stack.m_150930_((Item)ItemInit.DROP_UPGRADE.get());
                }
                return false;
            }
        };
    }

    protected ModEnergyStorage createEnergy() {
        return new ModEnergyStorage(true, (Integer)FarmingConfig.COCOA_BEANS_FARMER_CAPACITY.get(), (Integer)FarmingConfig.COCOA_BEANS_FARMER_USEPERTICK.get() * 2){

            protected void onEnergyChanged() {
                boolean newHasPower = CocoaFarmerBE.this.hasPowerToWork((Integer)FarmingConfig.COCOA_BEANS_FARMER_USEPERTICK.get());
                if (newHasPower) {
                    CocoaFarmerBE.this.f_58857_.m_7260_(CocoaFarmerBE.this.f_58858_, CocoaFarmerBE.this.m_58900_(), CocoaFarmerBE.this.m_58900_(), 3);
                }
                CocoaFarmerBE.this.m_6596_();
            }
        };
    }
}

