/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.blockentity;

import com.the_millman.farmingutils.common.blocks.CropFarmerBlock;
import com.the_millman.farmingutils.core.init.BlockEntityInit;
import com.the_millman.farmingutils.core.init.ItemInit;
import com.the_millman.farmingutils.core.tags.ModItemTags;
import com.the_millman.farmingutils.core.util.FarmingConfig;
import com.the_millman.themillmanlib.common.blockentity.ItemEnergyBlockEntity;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.ItemStackHandler;

public class CropFarmerBE
extends ItemEnergyBlockEntity {
    private int x;
    private int y;
    private int z;
    private int tick;
    int pX;
    int pZ;
    boolean initialized = false;
    int range;
    boolean needRedstone = false;
    boolean pickupDrops = true;

    public CropFarmerBE(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.CROP_FARMER.get(), pWorldPosition, pBlockState);
    }

    protected void init() {
        this.initialized = true;
        this.x = this.m_58899_().m_123341_() - 1;
        this.y = this.m_58899_().m_123342_();
        this.z = this.m_58899_().m_123343_() - 1;
        this.tick = 0;
        this.pX = 0;
        this.pZ = 0;
        this.range = 3;
        this.needRedstone = false;
        this.pickupDrops = true;
    }

    public void tickServer() {
        if (!this.initialized) {
            this.init();
        }
        if (this.hasPowerToWork((Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get())) {
            ++this.tick;
            if (this.tick == (Integer)FarmingConfig.CROP_FARMER_TICK.get()) {
                this.tick = 0;
                this.redstoneUpgrade();
                if (this.canWork()) {
                    this.upgradeSlot();
                    BlockPos posToBreak = new BlockPos(this.x + this.pX, this.y, this.z + this.pZ);
                    this.destroyBlock(posToBreak, false);
                    this.placeBlock(posToBreak);
                    this.m_6596_();
                    ++this.pX;
                    if (this.pX >= this.range) {
                        this.pX = 0;
                        ++this.pZ;
                        if (this.pZ >= this.range) {
                            this.pX = 0;
                            this.pZ = 0;
                        }
                    }
                }
            }
        }
    }

    private boolean canWork() {
        if (this.needRedstone) {
            return (Boolean)this.m_58900_().m_61143_((Property)CropFarmerBlock.POWERED) != false;
        }
        if (!this.needRedstone) {
            return true;
        }
        return true;
    }

    private void upgradeSlot() {
        this.rangeSlot();
        this.dropUpgrade();
    }

    private void rangeSlot() {
        ItemStack upgradeSlot = this.itemStorage.getStackInSlot(18);
        if (upgradeSlot.m_150930_((Item)ItemInit.IRON_UPGRADE.get())) {
            this.x = this.m_58899_().m_123341_() - 2;
            this.z = this.m_58899_().m_123343_() - 2;
            this.range = 5;
        } else if (upgradeSlot.m_150930_((Item)ItemInit.GOLD_UPGRADE.get())) {
            this.x = this.m_58899_().m_123341_() - 3;
            this.z = this.m_58899_().m_123343_() - 3;
            this.range = 7;
        } else if (upgradeSlot.m_150930_((Item)ItemInit.DIAMOND_UPGRADE.get())) {
            this.x = this.m_58899_().m_123341_() - 4;
            this.z = this.m_58899_().m_123343_() - 4;
            this.range = 9;
        } else {
            this.x = this.m_58899_().m_123341_() - 1;
            this.z = this.m_58899_().m_123343_() - 1;
            this.range = 3;
        }
    }

    private void redstoneUpgrade() {
        ItemStack upgradeSlot = this.itemStorage.getStackInSlot(19);
        if (upgradeSlot.m_150930_((Item)ItemInit.REDSTONE_UPGRADE.get())) {
            this.needRedstone = true;
        } else if (!upgradeSlot.m_150930_((Item)ItemInit.REDSTONE_UPGRADE.get())) {
            this.needRedstone = false;
        }
    }

    private void dropUpgrade() {
        ItemStack upgradeSlot = this.itemStorage.getStackInSlot(20);
        if (upgradeSlot.m_150930_((Item)ItemInit.DROP_UPGRADE.get())) {
            this.pickupDrops = false;
        } else if (!upgradeSlot.m_150930_((Item)ItemInit.DROP_UPGRADE.get())) {
            this.pickupDrops = true;
        }
    }

    private boolean destroyBlock(BlockPos pos, boolean dropBlock) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        if (this.getDestBlock(state)) {
            if (!this.f_58857_.f_46443_) {
                if (this.pickupDrops) {
                    this.collectDrops(pos, 0, 18);
                    this.f_58857_.m_46961_(pos, dropBlock);
                    this.energyStorage.consumeEnergy(((Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get()).intValue());
                    return true;
                }
                if (!this.pickupDrops) {
                    this.f_58857_.m_46961_(pos, true);
                    this.energyStorage.consumeEnergy(((Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get()).intValue());
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean placeBlock(BlockPos pos) {
        Item item;
        int slot = 0;
        for (int i = 0; i < 18; ++i) {
            if (this.itemStorage.getStackInSlot(i).m_41619_() || this.itemStorage.getStackInSlot(i).m_41619_() || !this.isValid(this.itemStorage.getStackInSlot(i))) continue;
            slot = i;
            break;
        }
        BlockPos posY = pos.m_7495_();
        BlockState state = this.f_58857_.m_8055_(pos);
        BlockState yState = this.f_58857_.m_8055_(posY);
        if (state.m_60734_() instanceof CropBlock) {
            return false;
        }
        if (yState.m_60734_() instanceof FarmBlock && this.isValid(this.itemStorage.getStackInSlot(slot)) && (item = this.itemStorage.getStackInSlot(slot).m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (!this.f_58857_.f_46443_) {
                Block block = blockItem.m_40614_();
                this.f_58857_.m_7731_(pos, block.m_49966_(), 3);
                this.f_58857_.m_5594_(null, pos, SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ItemStack stack = this.itemStorage.getStackInSlot(slot);
                stack.m_41774_(1);
                this.energyStorage.consumeEnergy(((Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get()).intValue());
            }
        }
        return false;
    }

    private boolean getDestBlock(BlockState state) {
        if (state.m_60734_() == Blocks.f_50444_ && (Integer)state.m_61143_((Property)BlockStateProperties.f_61407_) == 3) {
            return true;
        }
        if (state.m_60734_() != Blocks.f_50444_ && state.m_60734_() instanceof IPlantable && state.m_60734_() instanceof CropBlock) {
            return (Integer)state.m_61143_((Property)CropBlock.f_52244_) == 7;
        }
        return false;
    }

    private boolean isValid(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ItemNameBlockItem) {
            ItemNameBlockItem blockItem = (ItemNameBlockItem)item;
            return blockItem.m_40614_() instanceof CropBlock;
        }
        return false;
    }

    protected ItemStackHandler itemStorage() {
        return new ItemStackHandler(21){

            protected void onContentsChanged(int slot) {
                CropFarmerBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot < 18) {
                    return !CropFarmerBE.this.isValidUpgrade(stack);
                }
                if (slot >= 18 && CropFarmerBE.this.isValidUpgrade(stack)) {
                    if (slot == 18) {
                        return stack.m_150922_(ModItemTags.RANGE_UPGRADES);
                    }
                    if (slot == 19) {
                        return stack.m_150930_((Item)ItemInit.REDSTONE_UPGRADE.get());
                    }
                    return stack.m_150930_((Item)ItemInit.DROP_UPGRADE.get());
                }
                return false;
            }
        };
    }

    protected ModEnergyStorage createEnergy() {
        return new ModEnergyStorage(true, (Integer)FarmingConfig.CROP_FARMER_CAPACITY.get(), (Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get() * 2){

            protected void onEnergyChanged() {
                boolean newHasPower = CropFarmerBE.this.hasPowerToWork((Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get());
                if (newHasPower) {
                    CropFarmerBE.this.f_58857_.m_7260_(CropFarmerBE.this.f_58858_, CropFarmerBE.this.m_58900_(), CropFarmerBE.this.m_58900_(), 3);
                }
                CropFarmerBE.this.m_6596_();
            }
        };
    }
}

