/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.blockentity;

import com.the_millman.farmingutils.core.init.BlockEntityInit;
import com.the_millman.themillmanlib.common.blockentity.ItemEnergyBlockEntity;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.ItemStackHandler;

public class TestEnergyGenerator
extends ItemEnergyBlockEntity {
    private int counter;

    public TestEnergyGenerator(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.TEST_ENERGY_GENERATOR.get(), pWorldPosition, pBlockState);
    }

    public void tickServer() {
        BlockState blockState;
        ItemStack stack;
        int burnTime;
        if (this.counter > 0) {
            --this.counter;
            this.energyStorage.addEnergy(50);
            this.m_6596_();
        }
        if (this.counter <= 0 && (burnTime = ForgeHooks.getBurnTime((ItemStack)(stack = this.itemStorage.getStackInSlot(0)), (RecipeType)RecipeType.f_44108_)) > 0 && this.energyStorage.getEnergyStored() < 100000) {
            this.itemStorage.extractItem(0, 1, false);
            this.counter = burnTime / 4;
            this.m_6596_();
        }
        if ((Boolean)(blockState = this.f_58857_.m_8055_(this.f_58858_)).m_61143_((Property)BlockStateProperties.f_61448_) != this.counter > 0) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(this.counter > 0)), 5);
        }
        this.sendOutPower();
    }

    private void sendOutPower() {
        AtomicInteger capacity = new AtomicInteger(this.energyStorage.getEnergyStored());
        if (capacity.get() > 0) {
            for (Direction direction : Direction.values()) {
                boolean doContinue;
                BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
                if (te == null || (doContinue = te.getCapability(CapabilityEnergy.ENERGY, direction).map(handler -> {
                    if (handler.canReceive()) {
                        int received = handler.receiveEnergy(Math.min(capacity.get(), 1000), false);
                        capacity.addAndGet(-received);
                        this.energyStorage.consumeEnergy(received);
                        this.m_6596_();
                        return capacity.get() > 0;
                    }
                    return true;
                }).orElse(true).booleanValue())) continue;
                return;
            }
        }
    }

    protected ItemStackHandler itemStorage() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                TestEnergyGenerator.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) <= 0) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    protected ModEnergyStorage createEnergy() {
        return new ModEnergyStorage(false, 100000, 0){

            protected void onEnergyChanged() {
                TestEnergyGenerator.this.m_6596_();
            }

            public boolean canExtract() {
                return false;
            }
        };
    }

    protected void init() {
    }
}

