/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.themillmanlib.common.blockentity;

import com.the_millman.themillmanlib.common.items.UpgradeItem;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import com.the_millman.themillmanlib.core.util.BlockUtils;
import com.the_millman.themillmanlib.core.util.ModItemHandlerHelp;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ItemEnergyBlockEntity
extends BlockEntity {
    protected final ItemStackHandler itemStorage = this.itemStorage();
    private final LazyOptional<IItemHandler> inputSlotHandler = LazyOptional.of(() -> this.itemStorage);
    protected final ModEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);

    public ItemEnergyBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    protected boolean hasPowerToWork(int usePerTick) {
        return this.energyStorage.getEnergyStored() >= usePerTick;
    }

    protected abstract void init();

    public abstract void tickServer();

    protected void collectDrops(BlockPos pos, int minSlot, int maxSlot) {
        if (!this.f_58857_.f_46443_) {
            for (ItemStack blockDrops : BlockUtils.getBlockDrops(this.f_58857_, pos)) {
                ItemStack result = ModItemHandlerHelp.insertItemStacked((IItemHandler)this.itemStorage, blockDrops, minSlot, maxSlot, false);
                if (result.m_41619_()) continue;
                BlockUtils.spawnItemStack(result, this.f_58857_, pos);
            }
        }
    }

    protected void collectDrops(BlockPos pos) {
        if (!this.f_58857_.f_46443_) {
            for (ItemStack blockDrops : BlockUtils.getBlockDrops(this.f_58857_, pos)) {
                ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemStorage, (ItemStack)blockDrops, (boolean)false);
                if (result.m_41619_()) continue;
                BlockUtils.spawnItemStack(result, this.f_58857_, pos);
            }
        }
    }

    protected boolean isValidUpgrade(ItemStack stack) {
        return stack.m_41720_() instanceof UpgradeItem;
    }

    public void m_7651_() {
        this.inputSlotHandler.invalidate();
        this.energy.invalidate();
        super.m_7651_();
    }

    public void m_142466_(CompoundTag pTag) {
        if (pTag.m_128441_("InventorySlot")) {
            this.itemStorage.deserializeNBT(pTag.m_128469_("InventorySlot"));
        }
        if (pTag.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(pTag.m_128423_("Energy"));
        }
        super.m_142466_(pTag);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("InventorySlot", (Tag)this.itemStorage.serializeNBT());
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
        CompoundTag infoTag = new CompoundTag();
        tag.m_128365_("Info", (Tag)infoTag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inputSlotHandler.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    protected abstract ItemStackHandler itemStorage();

    protected abstract ModEnergyStorage createEnergy();
}

