/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.blockentity;

import com.the_millman.farmingutils.common.blocks.BambooFarmerBlock;
import com.the_millman.farmingutils.core.init.BlockEntityInit;
import com.the_millman.farmingutils.core.init.ItemInit;
import com.the_millman.farmingutils.core.tags.ModItemTags;
import com.the_millman.farmingutils.core.util.FarmingConfig;
import com.the_millman.themillmanlib.common.blockentity.ItemEnergyBlockEntity;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;

public class BambooFarmerBE
extends ItemEnergyBlockEntity {
    private int x;
    private int y;
    private int z;
    private int tick;
    int pX;
    int pZ;
    boolean initialized = false;
    int range;
    boolean needRedstone = false;
    boolean pickupDrops = true;

    public BambooFarmerBE(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.BAMBOO_FARMER.get(), pWorldPosition, pBlockState);
    }

    protected void init() {
        this.initialized = true;
        this.x = this.m_58899_().m_123341_() - 1;
        this.y = this.m_58899_().m_123342_() + 1;
        this.z = this.m_58899_().m_123343_() - 1;
        this.tick = 0;
        this.pX = 0;
        this.pZ = 0;
        this.range = 3;
        this.needRedstone = false;
        this.pickupDrops = true;
    }

    public void tickServer() {
        if (!this.initialized) {
            this.init();
        }
        if (this.hasPowerToWork((Integer)FarmingConfig.BAMBOO_FARMER_USEPERTICK.get())) {
            ++this.tick;
            if (this.tick == (Integer)FarmingConfig.BAMBOO_FARMER_TICK.get()) {
                this.tick = 0;
                this.redstoneUpgrade();
                if (this.canWork()) {
                    this.upgradeSlot();
                    BlockPos posToBreak = new BlockPos(this.x + this.pX, this.y, this.z + this.pZ);
                    this.destroyUpperBlock(posToBreak);
                    this.destroyBlock(posToBreak, false);
                    this.m_6596_();
                    ++this.pX;
                    if (this.pX >= this.range) {
                        this.pX = 0;
                        ++this.pZ;
                        if (this.pZ >= this.range) {
                            this.pX = 0;
                            this.pZ = 0;
                        }
                    }
                }
            }
        }
    }

    private boolean canWork() {
        if (this.needRedstone) {
            return (Boolean)this.m_58900_().m_61143_((Property)BambooFarmerBlock.POWERED) != false;
        }
        if (!this.needRedstone) {
            return true;
        }
        return true;
    }

    private void upgradeSlot() {
        this.rangeUpgrade();
        this.dropUpgrade();
    }

    private void redstoneUpgrade() {
        ItemStack upgradeSlot = this.itemStorage.getStackInSlot(10);
        if (upgradeSlot.m_150930_((Item)ItemInit.REDSTONE_UPGRADE.get())) {
            this.needRedstone = true;
        } else if (!upgradeSlot.m_150930_((Item)ItemInit.REDSTONE_UPGRADE.get())) {
            this.needRedstone = false;
        }
    }

    private void dropUpgrade() {
        ItemStack upgradeSlot = this.itemStorage.getStackInSlot(11);
        if (upgradeSlot.m_150930_((Item)ItemInit.DROP_UPGRADE.get())) {
            this.pickupDrops = false;
        } else if (!upgradeSlot.m_150930_((Item)ItemInit.DROP_UPGRADE.get())) {
            this.pickupDrops = true;
        }
    }

    private void rangeUpgrade() {
        ItemStack upgradeSlot = this.itemStorage.getStackInSlot(9);
        if (upgradeSlot.m_150930_((Item)ItemInit.IRON_UPGRADE.get())) {
            this.x = this.m_58899_().m_123341_() - 2;
            this.z = this.m_58899_().m_123343_() - 2;
            this.range = 5;
        } else if (upgradeSlot.m_150930_((Item)ItemInit.GOLD_UPGRADE.get())) {
            this.x = this.m_58899_().m_123341_() - 3;
            this.z = this.m_58899_().m_123343_() - 3;
            this.range = 7;
        } else if (upgradeSlot.m_150930_((Item)ItemInit.DIAMOND_UPGRADE.get())) {
            this.x = this.m_58899_().m_123341_() - 4;
            this.z = this.m_58899_().m_123343_() - 4;
            this.range = 9;
        } else if (upgradeSlot.m_41619_()) {
            this.x = this.m_58899_().m_123341_() - 1;
            this.z = this.m_58899_().m_123343_() - 1;
            this.range = 3;
        }
    }

    private boolean destroyBlock(BlockPos pos, boolean dropBlock) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        if (this.getDestBlock(state)) {
            if (!this.f_58857_.f_46443_) {
                if (this.pickupDrops) {
                    this.collectDrops(pos, 0, 9);
                    this.f_58857_.m_46961_(pos, dropBlock);
                    this.energyStorage.consumeEnergy(((Integer)FarmingConfig.BAMBOO_FARMER_USEPERTICK.get()).intValue());
                    return true;
                }
                if (!this.pickupDrops) {
                    this.f_58857_.m_46961_(pos, true);
                    this.energyStorage.consumeEnergy(((Integer)FarmingConfig.BAMBOO_FARMER_USEPERTICK.get()).intValue());
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean getDestBlock(BlockState state) {
        return state.m_60734_() == Blocks.f_50571_;
    }

    private void destroyUpperBlock(BlockPos pos) {
        this.f_58857_.m_8055_(pos.m_7494_());
        while (this.f_58857_.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50571_)) {
            this.destroyBlock(pos.m_7494_(), false);
            pos = new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
        }
    }

    protected ItemStackHandler itemStorage() {
        return new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                BambooFarmerBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot <= 8) {
                    if (stack.m_41720_() == Items.f_41911_) {
                        return true;
                    }
                } else if (slot > 8 && BambooFarmerBE.this.isValidUpgrade(stack)) {
                    if (slot == 9) {
                        return stack.m_204117_(ModItemTags.RANGE_UPGRADES);
                    }
                    if (slot == 10) {
                        return stack.m_150930_((Item)ItemInit.REDSTONE_UPGRADE.get());
                    }
                    if (slot == 11) {
                        return stack.m_150930_((Item)ItemInit.DROP_UPGRADE.get());
                    }
                }
                return false;
            }
        };
    }

    protected ModEnergyStorage createEnergy() {
        return new ModEnergyStorage(true, (Integer)FarmingConfig.BAMBOO_FARMER_CAPACITY.get(), (Integer)FarmingConfig.BAMBOO_FARMER_USEPERTICK.get() * 2){

            protected void onEnergyChanged() {
                boolean newHasPower = BambooFarmerBE.this.hasPowerToWork((Integer)FarmingConfig.BAMBOO_FARMER_USEPERTICK.get());
                if (newHasPower) {
                    BambooFarmerBE.this.f_58857_.m_7260_(BambooFarmerBE.this.f_58858_, BambooFarmerBE.this.m_58900_(), BambooFarmerBE.this.m_58900_(), 3);
                }
                BambooFarmerBE.this.m_6596_();
            }
        };
    }
}

