/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.themillmanlib.common.blockentity;

import com.the_millman.themillmanlib.common.items.UpgradeItem;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import com.the_millman.themillmanlib.core.util.BlockUtils;
import com.the_millman.themillmanlib.core.util.ModItemHandlerHelp;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ItemEnergyBlockEntity
extends BlockEntity {
    protected final ItemStackHandler itemStorage = this.itemStorage();
    private final LazyOptional<IItemHandler> inputSlotHandler = LazyOptional.of(() -> this.itemStorage);
    protected final ModEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    protected int x;
    protected int y;
    protected int z;
    protected int pX;
    protected int pZ;
    protected int range;

    public ItemEnergyBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    protected boolean hasPowerToWork(int usePerTick) {
        return this.energyStorage.getEnergyStored() >= usePerTick;
    }

    protected void consumeEnergy(int energyConsumed) {
        this.energyStorage.consumeEnergy(energyConsumed);
    }

    protected abstract void init();

    public abstract void tickServer();

    protected void posState() {
        ++this.pX;
        if (this.pX >= this.range) {
            this.pX = 0;
            ++this.pZ;
            if (this.pZ >= this.range) {
                this.pX = 0;
                this.pZ = 0;
            }
        }
    }

    protected void collectDrops(BlockPos pos, int minSlot, int maxSlot) {
        if (!this.f_58857_.f_46443_) {
            for (ItemStack blockDrops : BlockUtils.getBlockDrops(this.f_58857_, pos)) {
                ItemStack result = ModItemHandlerHelp.insertItemStacked((IItemHandler)this.itemStorage, blockDrops, minSlot, maxSlot, false);
                if (result.m_41619_()) continue;
                BlockUtils.spawnItemStack(result, this.f_58857_, pos);
            }
        }
    }

    protected void collectDrops(BlockPos pos) {
        if (!this.f_58857_.f_46443_) {
            for (ItemStack blockDrops : BlockUtils.getBlockDrops(this.f_58857_, pos)) {
                ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemStorage, (ItemStack)blockDrops, (boolean)false);
                if (result.m_41619_()) continue;
                BlockUtils.spawnItemStack(result, this.f_58857_, pos);
            }
        }
    }

    protected boolean isValidUpgrade(ItemStack stack) {
        return stack.m_41720_() instanceof UpgradeItem;
    }

    protected boolean isValidUpgrade(ItemStack stack, TagKey<Item> tag) {
        return stack.m_204117_(tag);
    }

    protected void consumeStack(int slot, int consume) {
        ItemStack stack = this.itemStorage.getStackInSlot(slot);
        stack.m_41774_(consume);
    }

    protected ItemStack getStackInSlot(int slot) {
        return this.itemStorage.getStackInSlot(slot);
    }

    protected int getUpgradeSlot(ItemStack upgrade, int minSlot, int maxSlot) {
        for (int i = minSlot; i <= maxSlot; ++i) {
            ItemStack upgradeItem = this.getStackInSlot(i);
            if (upgradeItem != upgrade) continue;
            return i;
        }
        return 0;
    }

    protected int getUpgradeSlot(TagKey<Item> upgrade, int minSlot, int maxSlot) {
        for (int i = minSlot; i <= maxSlot; ++i) {
            ItemStack upgradeItem = this.getStackInSlot(i);
            if (!upgradeItem.m_204117_(upgrade)) continue;
            return i;
        }
        return 0;
    }

    protected boolean getUpgrade(TagKey<Item> upgrade, int minSlot, int maxSlot) {
        int slot = this.getUpgradeSlot(upgrade, minSlot, maxSlot);
        boolean isUpgrade = this.itemStorage.getStackInSlot(slot).m_204117_(upgrade);
        return isUpgrade;
    }

    protected int getSlot(int maxSlot) {
        for (int i = 0; i < maxSlot; ++i) {
            if (this.getStackInSlot(i).m_41619_() || this.getStackInSlot(i).m_41619_() || !this.isValidBlock(this.getStackInSlot(i))) continue;
            return i;
        }
        return maxSlot;
    }

    protected abstract boolean isValidBlock(ItemStack var1);

    public void energyDebug(boolean debug) {
        ItemStack consumeItem;
        if (debug && (consumeItem = this.itemStorage.getStackInSlot(0)).m_41720_() == Items.f_42413_) {
            this.energyStorage.addEnergy(1000);
            consumeItem.m_41774_(1);
        }
    }

    public void m_7651_() {
        this.inputSlotHandler.invalidate();
        this.energy.invalidate();
        super.m_7651_();
    }

    public void m_142466_(CompoundTag pTag) {
        if (pTag.m_128441_("InventorySlot")) {
            this.itemStorage.deserializeNBT(pTag.m_128469_("InventorySlot"));
        }
        if (pTag.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(pTag.m_128423_("Energy"));
        }
        super.m_142466_(pTag);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("InventorySlot", (Tag)this.itemStorage.serializeNBT());
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
        CompoundTag infoTag = new CompoundTag();
        tag.m_128365_("Info", (Tag)infoTag);
        super.m_183515_(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inputSlotHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    protected abstract ItemStackHandler itemStorage();

    protected abstract ModEnergyStorage createEnergy();
}

