/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.themillmanlib.common.blockentity;

import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ItemEnergyFluidBlockEntity
extends BlockEntity {
    protected boolean needRedstone = false;
    protected final ItemStackHandler itemStorage = this.itemStorage();
    private final LazyOptional<IItemHandler> inputSlotHandler = LazyOptional.of(() -> this.itemStorage);
    protected final ModEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.energyStorage);
    protected final FluidTank fluidStorage = this.fluidStorage();
    private LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.fluidStorage);

    public ItemEnergyFluidBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    protected boolean hasPowerToWork(int usePerTick) {
        return this.energyStorage.getEnergyStored() >= usePerTick;
    }

    protected void consumeEnergy(int energyConsumed) {
        this.energyStorage.consumeEnergy(energyConsumed);
    }

    protected abstract void init();

    public void setFluid(FluidStack fluidStack) {
        this.fluidStorage.setFluid(fluidStack);
    }

    public FluidStack getFluidStack() {
        return this.fluidStorage.getFluid();
    }

    public void drain(int maxDrain, IFluidHandler.FluidAction action) {
        this.fluidStorage.drain(maxDrain, action);
    }

    public int getFluidAmount() {
        return this.fluidStorage.getFluidAmount();
    }

    protected static void transferItemFluidToFluidTank(ItemEnergyFluidBlockEntity pEntity, int slotI, int slotO) {
        pEntity.itemStorage.getStackInSlot(slotI).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
            int drainAmount = Math.min(pEntity.fluidStorage.getSpace(), 1000);
            FluidStack stack = handler.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
            if (pEntity.fluidStorage.isFluidValid(stack)) {
                stack = handler.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                ItemEnergyFluidBlockEntity.fillTankWithFluid(pEntity, stack, handler.getContainer(), slotI, slotO);
            }
        });
    }

    protected static void fillTankWithFluid(ItemEnergyFluidBlockEntity pEntity, FluidStack stack, ItemStack container, int slotI, int slotO) {
        pEntity.fluidStorage.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        pEntity.itemStorage.extractItem(slotI, 1, false);
        pEntity.itemStorage.insertItem(slotO, container, false);
    }

    protected static void transferItemFluidToFluidTank(ItemEnergyFluidBlockEntity pEntity, int slot) {
        pEntity.itemStorage.getStackInSlot(slot).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
            int drainAmount = Math.min(pEntity.fluidStorage.getSpace(), 1000);
            FluidStack stack = handler.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
            if (pEntity.fluidStorage.isFluidValid(stack)) {
                stack = handler.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                ItemEnergyFluidBlockEntity.fillTankWithFluid(pEntity, stack, handler.getContainer(), slot);
            }
        });
    }

    protected static void fillTankWithFluid(ItemEnergyFluidBlockEntity pEntity, FluidStack stack, ItemStack container, int slot) {
        pEntity.fluidStorage.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        pEntity.itemStorage.extractItem(slot, 1, false);
        pEntity.itemStorage.insertItem(slot, container, false);
    }

    @Deprecated(forRemoval=true, since="0.1.1")
    protected boolean getUpgrade(int minSlot, int maxSlot, Item upgradeItem) {
        for (int i = minSlot; i <= maxSlot; ++i) {
            ItemStack upgradeSlot = this.itemStorage.getStackInSlot(i);
            if (upgradeSlot.m_150930_(upgradeItem)) {
                this.needRedstone = true;
                return true;
            }
            if (upgradeSlot.m_150930_(upgradeItem)) continue;
            this.needRedstone = false;
        }
        return false;
    }

    protected void consumeStack(int slot, int consume) {
        ItemStack stack = this.itemStorage.getStackInSlot(slot);
        stack.m_41774_(consume);
    }

    protected ItemStack getStackInSlot(int slot) {
        return this.itemStorage.getStackInSlot(slot);
    }

    protected int getUpgradeSlot(ItemStack upgrade, int minSlot, int maxSlot) {
        for (int i = minSlot; i <= maxSlot; ++i) {
            ItemStack upgradeItem = this.getStackInSlot(i);
            if (upgradeItem != upgrade) continue;
            return i;
        }
        return 0;
    }

    protected int getUpgradeSlot(TagKey<Item> upgrade, int minSlot, int maxSlot) {
        for (int i = minSlot; i <= maxSlot; ++i) {
            ItemStack upgradeItem = this.getStackInSlot(i);
            if (!upgradeItem.m_204117_(upgrade)) continue;
            return i;
        }
        return 0;
    }

    protected boolean getUpgrade(TagKey<Item> upgrade, int minSlot, int maxSlot) {
        int slot = this.getUpgradeSlot(upgrade, minSlot, maxSlot);
        boolean isUpgrade = this.itemStorage.getStackInSlot(slot).m_204117_(upgrade);
        return isUpgrade;
    }

    protected int getSlot(int maxSlot) {
        for (int i = 0; i < 18; ++i) {
            if (this.getStackInSlot(i).m_41619_() || this.getStackInSlot(i).m_41619_() || !this.isValidBlock(this.getStackInSlot(i))) continue;
            return i;
        }
        return maxSlot;
    }

    protected abstract boolean isValidBlock(ItemStack var1);

    public void energyDebug(boolean debug) {
        ItemStack consumeItem;
        if (debug && (consumeItem = this.itemStorage.getStackInSlot(0)).m_41720_() == Items.f_42413_) {
            this.energyStorage.addEnergy(1000);
            consumeItem.m_41774_(1);
        }
    }

    public void m_7651_() {
        this.inputSlotHandler.invalidate();
        this.fluidHandler.invalidate();
        this.energy.invalidate();
        super.m_7651_();
    }

    public void onLoad() {
        this.fluidHandler = LazyOptional.of(() -> this.fluidStorage);
        super.onLoad();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inputSlotHandler.invalidate();
        this.energy.invalidate();
        this.fluidHandler.invalidate();
    }

    public void m_142466_(CompoundTag pTag) {
        if (pTag.m_128441_("InventorySlot")) {
            this.itemStorage.deserializeNBT(pTag.m_128469_("InventorySlot"));
        }
        if (pTag.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(pTag.m_128423_("Energy"));
        }
        this.fluidStorage.readFromNBT(pTag);
        super.m_142466_(pTag);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("InventorySlot", (Tag)this.itemStorage.serializeNBT());
        pTag.m_128365_("Energy", this.energyStorage.serializeNBT());
        pTag = this.fluidStorage.writeToNBT(pTag);
        CompoundTag infoTag = new CompoundTag();
        pTag.m_128365_("Info", (Tag)infoTag);
        super.m_183515_(pTag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inputSlotHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected abstract ItemStackHandler itemStorage();

    protected abstract ModEnergyStorage createEnergy();

    protected abstract FluidTank fluidStorage();
}

