/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.themillmanlib.common.containers;

import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ItemEnergyContainer
extends AbstractContainerMenu {
    protected BlockEntity blockEntity;
    protected Player playerEntity;
    protected IItemHandler playerInventory;

    public ItemEnergyContainer(MenuType<?> pMenuType, int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player) {
        super(pMenuType, windowId);
        this.blockEntity = world.m_7702_(pos);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.trackPower();
    }

    public boolean m_6875_(Player pPlayer) {
        return false;
    }

    protected void trackPower() {
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return ItemEnergyContainer.this.getEnergy() & 0xFFFF;
            }

            public void m_6422_(int value) {
                ItemEnergyContainer.this.blockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(h -> {
                    int energyStored = h.getEnergyStored() & 0xFFFF0000;
                    ((ModEnergyStorage)((Object)h)).setEnergy(energyStored + (value & 0xFFFF));
                });
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return ItemEnergyContainer.this.getEnergy() >> 16 & 0xFFFF;
            }

            public void m_6422_(int value) {
                ItemEnergyContainer.this.blockEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(h -> {
                    int energyStored = h.getEnergyStored() & 0xFFFF;
                    ((ModEnergyStorage)((Object)h)).setEnergy(energyStored | value << 16);
                });
            }
        });
    }

    public int getEnergy() {
        return this.blockEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getEnergyStored).orElse(0);
    }

    public int getMaxEnergyStored() {
        return this.blockEntity.getCapability(ForgeCapabilities.ENERGY).map(IEnergyStorage::getMaxEnergyStored).orElse(0);
    }

    protected int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    protected int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    protected void layoutPlayerInventorySlots(IItemHandler playerInventory, int leftCol, int topRow) {
        this.addSlotBox(playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    protected void layoutInventorySlots(IItemHandler handler, int x, int y, int slotRow, int slotColumn) {
        for (int row = 0; row < slotRow; ++row) {
            for (int column = 0; column < slotColumn; ++column) {
                this.m_38897_((Slot)new SlotItemHandler(handler, row * slotColumn + column, x + column * 18, y + row * 18));
            }
        }
    }

    protected void layoutUpgradeSlots(IItemHandler handler, int index, int x, int y, int slotColumn) {
        for (int column = 0; column < slotColumn; ++column) {
            this.m_38897_((Slot)new SlotItemHandler(handler, column + index, x, y + column * 18));
        }
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        return null;
    }
}

