/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.themillmanlib.core.energy;

import net.minecraftforge.energy.EnergyStorage;

public class ModEnergyStorage
extends EnergyStorage {
    private final boolean isReciver;

    public ModEnergyStorage(boolean isReciver, int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
        this.isReciver = isReciver;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.isReciver) {
            if (!this.canReceive()) {
                return 0;
            }
            int energyReceived = Math.min(this.capacity - this.energy, Math.min(this.maxReceive, maxReceive));
            if (!simulate) {
                this.energy += energyReceived;
            }
            return energyReceived;
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return super.extractEnergy(maxExtract, simulate);
    }

    public boolean canExtract() {
        return false;
    }

    protected void onEnergyChanged() {
    }

    public void setEnergy(int energy) {
        this.energy = energy;
        this.onEnergyChanged();
    }

    public void addEnergy(int energy) {
        this.energy += energy;
        if (this.energy > this.getMaxEnergyStored()) {
            this.energy = this.getEnergyStored();
        }
        this.onEnergyChanged();
    }

    public void consumeEnergy(int energy) {
        this.energy -= energy;
        if (this.energy < 0) {
            this.energy = 0;
        }
        this.onEnergyChanged();
    }

    public boolean canReceive() {
        return this.isReciver;
    }
}

