/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.blockentity;

import com.the_millman.farmingutils.common.blocks.CactusFarmerBlock;
import com.the_millman.farmingutils.core.init.BlockEntityInit;
import com.the_millman.farmingutils.core.util.FarmingConfig;
import com.the_millman.themillmanlib.common.blockentity.ItemEnergyBlockEntity;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import com.the_millman.themillmanlib.core.util.LibTags;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;

public class CactusFarmerBE
extends ItemEnergyBlockEntity {
    private int tick;
    boolean initialized = false;
    boolean needRedstone = false;
    boolean pickupDrops = true;

    public CactusFarmerBE(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.CACTUS_FARMER.get(), pWorldPosition, pBlockState);
    }

    protected void init() {
        this.initialized = true;
        this.x = this.m_58899_().m_123341_() - 1;
        this.y = this.m_58899_().m_123342_() + 1;
        this.z = this.m_58899_().m_123343_() - 1;
        this.tick = 0;
        this.pX = 0;
        this.pZ = 0;
        this.range = 3;
        this.needRedstone = false;
        this.pickupDrops = true;
    }

    public void tickServer() {
        if (!this.initialized) {
            this.init();
        }
        if (this.hasPowerToWork((Integer)FarmingConfig.CACTUS_FARMER_USEPERTICK.get())) {
            ++this.tick;
            if (this.tick == (Integer)FarmingConfig.CACTUS_FARMER_TICK.get()) {
                this.tick = 0;
                this.getUpgrade(LibTags.Items.REDSTONE_UPGRADE, 9, 11);
                if (this.canWork()) {
                    this.upgradeSlot();
                    BlockPos posToBreak = new BlockPos(this.x + this.pX, this.y, this.z + this.pZ);
                    this.destroyUpperBlock(posToBreak);
                    this.destroyBlock(posToBreak, false);
                    this.m_6596_();
                    this.posState();
                }
            }
        }
    }

    private boolean canWork() {
        if (this.needRedstone) {
            return (Boolean)this.m_58900_().m_61143_((Property)CactusFarmerBlock.POWERED) != false;
        }
        if (!this.needRedstone) {
            return true;
        }
        return true;
    }

    private void upgradeSlot() {
        this.rangeUpgrade();
        this.pickupDrops = !this.getUpgrade(LibTags.Items.DROP_UPGRADE, 9, 11);
    }

    private void rangeUpgrade() {
        boolean ironUpgrade = this.getUpgrade(LibTags.Items.IRON_RANGE_UPGRADE, 9, 11);
        boolean goldUpgrade = this.getUpgrade(LibTags.Items.GOLD_RANGE_UPGRADE, 9, 11);
        boolean diamondUpgrade = this.getUpgrade(LibTags.Items.DIAMOND_RANGE_UPGRADE, 9, 11);
        if (ironUpgrade) {
            this.x = this.m_58899_().m_123341_() - 2;
            this.z = this.m_58899_().m_123343_() - 2;
            this.range = 5;
        } else if (goldUpgrade) {
            this.x = this.m_58899_().m_123341_() - 3;
            this.z = this.m_58899_().m_123343_() - 3;
            this.range = 7;
        } else if (diamondUpgrade) {
            this.x = this.m_58899_().m_123341_() - 4;
            this.z = this.m_58899_().m_123343_() - 4;
            this.range = 9;
        } else {
            this.x = this.m_58899_().m_123341_() - 1;
            this.z = this.m_58899_().m_123343_() - 1;
            this.range = 3;
        }
    }

    private boolean destroyBlock(BlockPos pos, boolean dropBlock) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        if (this.getDestBlock(state)) {
            if (!this.f_58857_.f_46443_) {
                if (this.pickupDrops) {
                    this.collectDrops(pos, 0, 9);
                    this.f_58857_.m_46961_(pos, dropBlock);
                    this.consumeEnergy((Integer)FarmingConfig.CACTUS_FARMER_USEPERTICK.get());
                    return true;
                }
                if (!this.pickupDrops) {
                    this.f_58857_.m_46961_(pos, true);
                    this.consumeEnergy((Integer)FarmingConfig.CACTUS_FARMER_USEPERTICK.get());
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private void destroyUpperBlock(BlockPos pos) {
        this.f_58857_.m_8055_(pos.m_7494_());
        while (this.f_58857_.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50128_)) {
            this.destroyBlock(pos.m_7494_(), false);
            pos = new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
        }
    }

    private boolean getDestBlock(BlockState state) {
        return state.m_60734_() == Blocks.f_50128_;
    }

    protected boolean isValidBlock(ItemStack stack) {
        return false;
    }

    protected ItemStackHandler itemStorage() {
        return new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                CactusFarmerBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return slot <= 8 ? stack.m_41720_() == Items.f_41982_ : slot > 8 && CactusFarmerBE.this.isValidUpgrade(stack);
            }
        };
    }

    protected ModEnergyStorage createEnergy() {
        return new ModEnergyStorage(true, (Integer)FarmingConfig.CACTUS_FARMER_CAPACITY.get(), (Integer)FarmingConfig.CACTUS_FARMER_USEPERTICK.get() * 2){

            protected void onEnergyChanged() {
                boolean newHasPower = CactusFarmerBE.this.hasPowerToWork((Integer)FarmingConfig.CACTUS_FARMER_USEPERTICK.get());
                if (newHasPower) {
                    CactusFarmerBE.this.f_58857_.m_7260_(CactusFarmerBE.this.f_58858_, CactusFarmerBE.this.m_58900_(), CactusFarmerBE.this.m_58900_(), 3);
                }
                CactusFarmerBE.this.m_6596_();
            }
        };
    }
}

