/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.blockentity;

import com.the_millman.farmingutils.common.blocks.InternalFarmerBlock;
import com.the_millman.farmingutils.core.init.BlockEntityInit;
import com.the_millman.farmingutils.core.init.ItemInit;
import com.the_millman.farmingutils.core.networking.FluidSyncS2CPacket;
import com.the_millman.farmingutils.core.networking.ItemStackSyncS2CPacket2;
import com.the_millman.farmingutils.core.networking.ModMessages;
import com.the_millman.farmingutils.core.util.FarmingConfig;
import com.the_millman.themillmanlib.common.blockentity.ItemEnergyFluidBlockEntity;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import com.the_millman.themillmanlib.core.util.BlockUtils;
import com.the_millman.themillmanlib.core.util.LibTags;
import com.the_millman.themillmanlib.core.util.ModItemHandlerHelp;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class InternalFarmerBE
extends ItemEnergyFluidBlockEntity {
    private int tick;
    private int growthStage;
    private int maxGrowthStage = 5;
    boolean initialized = false;
    BlockPos pos;

    public InternalFarmerBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.INTERNAL_FARMER.get(), pPos, pBlockState);
    }

    protected void init() {
        this.initialized = true;
        this.tick = 0;
        this.resetGrowthStage();
        this.needRedstone = false;
        this.pos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
    }

    public void tickServer(InternalFarmerBE pEntity) {
        ItemStack bucketStack;
        if (!this.initialized) {
            this.init();
        }
        if ((bucketStack = this.itemStorage.getStackInSlot(13)).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            InternalFarmerBE.transferItemFluidToFluidTank((ItemEnergyFluidBlockEntity)pEntity, (int)13, (int)14);
            this.m_6596_();
        }
        if (this.hasPowerToWork((Integer)FarmingConfig.INTERNAL_FARMER_USEPERTICK.get()) && this.getFluidAmount() >= (Integer)FarmingConfig.INTERNAL_FARMER_FLUID_CONSUMED.get()) {
            ++this.tick;
            if (this.tick == (Integer)FarmingConfig.INTERNAL_FARMER_TICK.get()) {
                this.tick = 0;
                this.needRedstone = this.getUpgrade(LibTags.Items.REDSTONE_UPGRADE, 9, 11);
                if (this.canWork()) {
                    this.updateGrowthStage();
                    if (this.growthStage >= this.maxGrowthStage) {
                        this.farm(this.pos);
                        this.growthStage = 1;
                        this.resetGrowthStage();
                        this.m_6596_();
                    }
                }
            }
        }
    }

    public float getScaledProgress() {
        float standardSize = 1.0f;
        int progess = this.growthStage;
        int maxProgress = this.maxGrowthStage;
        return maxProgress != 0 && progess != 0 ? (float)progess * standardSize / (float)maxProgress : 0.0f;
    }

    private boolean canWork() {
        if (this.needRedstone) {
            return (Boolean)this.m_58900_().m_61143_((Property)InternalFarmerBlock.POWERED) != false;
        }
        if (!this.needRedstone) {
            return true;
        }
        return true;
    }

    private boolean farm(BlockPos pos) {
        ItemStack stack = this.getStackInSlot(12);
        if (this.isValidItem(stack) && !this.f_58857_.m_5776_()) {
            ItemStack copy = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)2);
            if (!copy.m_41619_()) {
                if (copy.m_150930_(Items.f_41910_)) {
                    this.drain((Integer)FarmingConfig.INTERNAL_FARMER_FLUID_CONSUMED.get() * 2, IFluidHandler.FluidAction.EXECUTE);
                    this.consumeEnergy((Integer)FarmingConfig.INTERNAL_FARMER_USEPERTICK.get());
                } else {
                    this.drain((Integer)FarmingConfig.INTERNAL_FARMER_FLUID_CONSUMED.get(), IFluidHandler.FluidAction.EXECUTE);
                    this.consumeEnergy((Integer)FarmingConfig.INTERNAL_FARMER_USEPERTICK.get());
                }
                ItemStack result = ModItemHandlerHelp.insertItemStacked((IItemHandler)this.itemStorage, (ItemStack)copy, (int)0, (int)9, (boolean)false);
                if (!result.m_41619_()) {
                    BlockUtils.spawnItemStack((ItemStack)copy, (Level)this.f_58857_, (BlockPos)pos);
                }
                this.m_6596_();
            }
            this.m_6596_();
            return true;
        }
        return false;
    }

    private boolean isValidItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (blockItem.m_40614_() instanceof IPlantable || stack.m_150930_(Items.f_41910_)) {
                return stack.m_204117_(ItemTags.f_13145_) || stack.m_204117_(ItemTags.f_13148_) || stack.m_150930_(Items.f_41952_) || stack.m_150930_(Items.f_41953_) || stack.m_150930_(Items.f_41910_);
            }
            return false;
        }
        return false;
    }

    public ItemStack getRenderStack() {
        return this.getStackInSlot(12);
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemStorage.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    protected boolean isValidBlock(ItemStack stack) {
        return false;
    }

    protected ItemStackHandler itemStorage() {
        return new ItemStackHandler(15){

            protected void onContentsChanged(int slot) {
                InternalFarmerBE.this.m_6596_();
                if (!InternalFarmerBE.this.f_58857_.m_5776_()) {
                    ModMessages.sendToClients(new ItemStackSyncS2CPacket2(this, InternalFarmerBE.this.f_58858_));
                }
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot <= 8) {
                    return true;
                }
                if (slot >= 9 && slot <= 11) {
                    return stack.m_150930_((Item)ItemInit.REDSTONE_UPGRADE.get());
                }
                if (slot == 12) {
                    Item item = stack.m_41720_();
                    if (item instanceof BlockItem) {
                        BlockItem blockItem = (BlockItem)item;
                        if (blockItem.m_40614_() instanceof IPlantable || stack.m_150930_(Items.f_41910_)) {
                            return stack.m_204117_(ItemTags.f_13145_) || stack.m_204117_(ItemTags.f_13148_) || stack.m_150930_(Items.f_41952_) || stack.m_150930_(Items.f_41953_) || stack.m_150930_(Items.f_41910_);
                        }
                        return false;
                    }
                    return false;
                }
                if (slot == 13) {
                    return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
                }
                if (slot == 14) {
                    return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
                }
                return false;
            }
        };
    }

    protected ModEnergyStorage createEnergy() {
        return new ModEnergyStorage(true, (Integer)FarmingConfig.INTERNAL_FARMER_CAPACITY.get(), (Integer)FarmingConfig.INTERNAL_FARMER_USEPERTICK.get() * 2){

            protected void onEnergyChanged() {
                boolean newHasPower = InternalFarmerBE.this.hasPowerToWork((Integer)FarmingConfig.INTERNAL_FARMER_USEPERTICK.get());
                if (newHasPower) {
                    InternalFarmerBE.this.f_58857_.m_7260_(InternalFarmerBE.this.f_58858_, InternalFarmerBE.this.m_58900_(), InternalFarmerBE.this.m_58900_(), 3);
                }
                InternalFarmerBE.this.m_6596_();
            }
        };
    }

    protected FluidTank fluidStorage() {
        return new FluidTank((Integer)FarmingConfig.INTERNAL_FARMER_FLUID_CAPACITY.get()){

            protected void onContentsChanged() {
                InternalFarmerBE.this.m_6596_();
                if (!InternalFarmerBE.this.f_58857_.m_5776_()) {
                    ModMessages.sendToClients(new FluidSyncS2CPacket(this.fluid, InternalFarmerBE.this.f_58858_));
                }
            }

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid() == Fluids.f_76193_;
            }
        };
    }

    private void resetGrowthStage() {
        this.growthStage = 1;
    }

    private void updateGrowthStage() {
        ++this.growthStage;
    }

    public void setGrowthStage(int growthStage) {
        this.growthStage = growthStage;
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128405_("growth_stage", this.growthStage);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.growthStage = pTag.m_128451_("growth_stage");
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }
}

