/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.blockentity;

import com.the_millman.farmingutils.common.blocks.NetherWartFarmerBlock;
import com.the_millman.farmingutils.core.init.BlockEntityInit;
import com.the_millman.farmingutils.core.util.FarmingConfig;
import com.the_millman.themillmanlib.common.blockentity.ItemEnergyBlockEntity;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import com.the_millman.themillmanlib.core.util.LibTags;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;

public class NetherWartFarmerBE
extends ItemEnergyBlockEntity {
    private int tick;
    boolean initialized = false;
    boolean needRedstone = false;
    boolean pickupDrops = true;

    public NetherWartFarmerBE(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.NETHER_WART_FARMER.get(), pWorldPosition, pBlockState);
    }

    protected void init() {
        this.initialized = true;
        this.x = this.m_58899_().m_123341_() - 1;
        this.y = this.m_58899_().m_123342_();
        this.z = this.m_58899_().m_123343_() - 1;
        this.tick = 0;
        this.pX = 0;
        this.pZ = 0;
        this.range = 3;
        this.needRedstone = false;
        this.pickupDrops = true;
    }

    public void tickServer() {
        if (!this.initialized) {
            this.init();
        }
        if (this.hasPowerToWork((Integer)FarmingConfig.NETHER_WART_FARMER_USEPERTICK.get())) {
            ++this.tick;
            if (this.tick == (Integer)FarmingConfig.NETHER_WART_FARMER_TICK.get()) {
                this.tick = 0;
                this.needRedstone = this.getUpgrade(LibTags.Items.REDSTONE_UPGRADE, 9, 11);
                if (this.canWork()) {
                    this.upgradeSlot();
                    BlockPos posToBreak = new BlockPos(this.x + this.pX, this.y, this.z + this.pZ);
                    this.destroyBlock(posToBreak, false);
                    this.placeBlock(posToBreak);
                    this.m_6596_();
                    this.posState();
                }
            }
        }
    }

    private boolean canWork() {
        if (this.needRedstone) {
            return (Boolean)this.m_58900_().m_61143_((Property)NetherWartFarmerBlock.POWERED) != false;
        }
        if (!this.needRedstone) {
            return true;
        }
        return true;
    }

    private void upgradeSlot() {
        this.rangeUpgrade();
        this.pickupDrops = !this.getUpgrade(LibTags.Items.DROP_UPGRADE, 9, 11);
    }

    private void rangeUpgrade() {
        boolean ironUpgrade = this.getUpgrade(LibTags.Items.IRON_RANGE_UPGRADE, 9, 11);
        boolean goldUpgrade = this.getUpgrade(LibTags.Items.GOLD_RANGE_UPGRADE, 9, 11);
        boolean diamondUpgrade = this.getUpgrade(LibTags.Items.DIAMOND_RANGE_UPGRADE, 9, 11);
        if (ironUpgrade) {
            this.x = this.m_58899_().m_123341_() - 2;
            this.z = this.m_58899_().m_123343_() - 2;
            this.range = 5;
        } else if (goldUpgrade) {
            this.x = this.m_58899_().m_123341_() - 3;
            this.z = this.m_58899_().m_123343_() - 3;
            this.range = 7;
        } else if (diamondUpgrade) {
            this.x = this.m_58899_().m_123341_() - 4;
            this.z = this.m_58899_().m_123343_() - 4;
            this.range = 9;
        } else {
            this.x = this.m_58899_().m_123341_() - 1;
            this.z = this.m_58899_().m_123343_() - 1;
            this.range = 3;
        }
    }

    private boolean destroyBlock(BlockPos pos, boolean dropBlock) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        if (this.getDestBlock(state)) {
            if (!this.f_58857_.f_46443_) {
                if (this.pickupDrops) {
                    this.collectDrops(pos, 0, 9);
                    this.f_58857_.m_46961_(pos, dropBlock);
                    this.consumeEnergy((Integer)FarmingConfig.NETHER_WART_FARMER_USEPERTICK.get());
                    return true;
                }
                if (!this.pickupDrops) {
                    this.f_58857_.m_46961_(pos, true);
                    this.consumeEnergy((Integer)FarmingConfig.NETHER_WART_FARMER_USEPERTICK.get());
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean placeBlock(BlockPos pos) {
        Item item;
        int slot = this.getSlot(9);
        BlockPos posY = pos.m_7495_();
        BlockState state = this.f_58857_.m_8055_(pos);
        BlockState yState = this.f_58857_.m_8055_(posY);
        if (state.m_60734_() == Blocks.f_50200_) {
            return false;
        }
        if (!state.m_60795_()) {
            return true;
        }
        if (yState.m_60713_(Blocks.f_50135_) && (item = this.getStackInSlot(slot).m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (!this.f_58857_.f_46443_ && blockItem.m_5456_() == Items.f_42588_) {
                Block block = blockItem.m_40614_();
                this.f_58857_.m_7731_(pos, block.m_49966_(), 3);
                this.f_58857_.m_5594_(null, pos, SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.consumeStack(slot, 1);
                this.consumeEnergy((Integer)FarmingConfig.NETHER_WART_FARMER_USEPERTICK.get());
                return true;
            }
        }
        return true;
    }

    private boolean getDestBlock(BlockState state) {
        return state.m_60734_() == Blocks.f_50200_ && (Integer)state.m_61143_((Property)BlockStateProperties.f_61407_) == 3;
    }

    protected boolean isValidBlock(ItemStack stack) {
        return stack.m_150930_(Items.f_42588_);
    }

    protected ItemStackHandler itemStorage() {
        return new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                NetherWartFarmerBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return slot <= 8 ? stack.m_41720_() == Items.f_42588_ : slot > 8 && NetherWartFarmerBE.this.isValidUpgrade(stack);
            }
        };
    }

    protected ModEnergyStorage createEnergy() {
        return new ModEnergyStorage(true, (Integer)FarmingConfig.NETHER_WART_FARMER_CAPACITY.get(), (Integer)FarmingConfig.NETHER_WART_FARMER_USEPERTICK.get() * 2){

            protected void onEnergyChanged() {
                boolean newHasPower = NetherWartFarmerBE.this.hasPowerToWork((Integer)FarmingConfig.NETHER_WART_FARMER_USEPERTICK.get());
                if (newHasPower) {
                    NetherWartFarmerBE.this.f_58857_.m_7260_(NetherWartFarmerBE.this.f_58858_, NetherWartFarmerBE.this.m_58900_(), NetherWartFarmerBE.this.m_58900_(), 3);
                }
                NetherWartFarmerBE.this.m_6596_();
            }
        };
    }
}

