/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.blockentity;

import com.the_millman.themillmanlib.common.blockentity.interfaces.IEnergyStorageHelper;
import com.the_millman.themillmanlib.common.blockentity.interfaces.IItemStorageHelper;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBaseBE
extends BlockEntity
implements IEnergyStorageHelper,
IItemStorageHelper {
    protected final ItemStackHandler itemStorage = this.createInputItemHandler();
    protected final LazyOptional<IItemHandler> inputItemHandler = LazyOptional.of(() -> this.itemStorage);
    protected final ItemStackHandler upgradeItems = this.createUpgradeItemHandler();
    protected final LazyOptional<IItemHandler> upgradeItemHandler = LazyOptional.of(() -> this.upgradeItems);
    protected final LazyOptional<IItemHandler> combinedItemHandler = LazyOptional.of(this::createCombinedItemHandler);
    protected final ModEnergyStorage energyStorage = this.createEnergyStorage();
    protected final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    protected int x;
    protected int y;
    protected int z;
    protected int pX;
    protected int pZ;
    protected int range;

    public AbstractBaseBE(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    protected abstract void init();

    public abstract void tickServer();

    protected void posState() {
        ++this.pX;
        if (this.pX >= this.range) {
            this.pX = 0;
            ++this.pZ;
            if (this.pZ >= this.range) {
                this.pX = 0;
                this.pZ = 0;
            }
        }
    }

    public abstract boolean isValidBlock(ItemStack var1);

    public void energyDebug(boolean debug) {
        ItemStack consumeItem;
        if (debug && (consumeItem = this.itemStorage.getStackInSlot(0)).m_41720_() == Items.f_42413_) {
            this.energyStorage.addEnergy(1000);
            consumeItem.m_41774_(1);
        }
    }

    protected abstract ModEnergyStorage createEnergyStorage();

    protected abstract ItemStackHandler createUpgradeItemHandler();

    protected abstract ItemStackHandler createInputItemHandler();

    protected abstract IItemHandler createCombinedItemHandler();

    public void m_7651_() {
        super.m_7651_();
        this.inputItemHandler.invalidate();
        this.upgradeItemHandler.invalidate();
        this.combinedItemHandler.invalidate();
        this.energyHandler.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("InventorySlot", (Tag)this.itemStorage.serializeNBT());
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("InventorySlot")) {
            this.itemStorage.deserializeNBT(tag.m_128469_("InventorySlot"));
        }
        if (tag.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                this.upgradeItemHandler.cast();
                return this.combinedItemHandler.cast();
            }
            return this.inputItemHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

