/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.blockentity;

import com.the_millman.farmingutils.common.blocks.CocoaFarmerBlock;
import com.the_millman.farmingutils.core.init.BlockEntityInit;
import com.the_millman.farmingutils.core.util.FarmingConfig;
import com.the_millman.themillmanlib.common.blockentity.ItemEnergyBlockEntity;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import com.the_millman.themillmanlib.core.util.LibTags;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class CocoaFarmerBE
extends ItemEnergyBlockEntity {
    private final int UP_SLOT_MIN = 0;
    private final int UP_SLOT_MAX = 2;
    private int tick;
    int pY;
    boolean initialized = false;
    BlockPos facingPos = null;
    boolean needRedstone = false;
    boolean pickupDrops = true;

    public CocoaFarmerBE(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.COCOA_BEANS_FARMER.get(), pWorldPosition, pBlockState);
    }

    protected void init() {
        this.initialized = true;
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CocoaFarmerBlock.f_54117_);
        if (facing == Direction.NORTH) {
            this.x = this.m_58899_().m_123341_();
            this.z = this.m_58899_().m_123343_() - 2;
        } else if (facing == Direction.SOUTH) {
            this.x = this.m_58899_().m_123341_();
            this.z = this.m_58899_().m_123343_() + 2;
        } else if (facing == Direction.WEST) {
            this.x = this.m_58899_().m_123341_() - 2;
            this.z = this.m_58899_().m_123343_();
        } else if (facing == Direction.EAST) {
            this.x = this.m_58899_().m_123341_() + 2;
            this.z = this.m_58899_().m_123343_();
        }
        this.y = this.m_58899_().m_123342_();
        this.tick = 0;
        this.pX = 0;
        this.pY = 0;
        this.pZ = 0;
        this.range = 1;
        this.facingPos = this.m_58899_();
        this.needRedstone = false;
        this.pickupDrops = true;
    }

    public void tickServer() {
        if (!this.initialized) {
            this.init();
        }
        if (this.hasPowerToWork(this.energyStorage, (Boolean)FarmingConfig.FARMERS_NEEDS_ENERGY.get(), (Integer)FarmingConfig.COCOA_BEANS_FARMER_USEPERTICK.get())) {
            ++this.tick;
            if (this.tick == (Integer)FarmingConfig.COCOA_BEANS_FARMER_TICK.get()) {
                this.tick = 0;
                this.needRedstone = this.getUpgrade((TagKey<Item>)LibTags.Items.REDSTONE_UPGRADE);
                if (this.canWork()) {
                    this.upgradeSlot();
                    BlockPos posToBreak = new BlockPos(this.x + this.pX, this.y + this.pY, this.z + this.pZ);
                    this.destroyBlock(posToBreak, false);
                    this.placeBlock(posToBreak);
                    this.m_6596_();
                    this.stadioState();
                }
            }
        }
    }

    private void upgradeSlot() {
        this.rangeUpgrade();
        this.pickupDrops = !this.getUpgrade((TagKey<Item>)LibTags.Items.DROP_UPGRADE);
    }

    private void stadioState() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CocoaFarmerBlock.f_54117_);
        if (facing == Direction.NORTH) {
            ++this.pY;
            if (this.pY == 5) {
                this.pY = 0;
                ++this.pX;
                if (this.pX >= this.range) {
                    this.pX = 0;
                    this.pY = 0;
                }
            }
        } else if (facing == Direction.SOUTH) {
            ++this.pY;
            if (this.pY == 5) {
                this.pY = 0;
                --this.pX;
                if (this.pX <= -this.range) {
                    this.pX = 0;
                    this.pY = 0;
                }
            }
        } else if (facing == Direction.WEST) {
            ++this.pY;
            if (this.pY == 5) {
                this.pY = 0;
                --this.pZ;
                if (this.pZ <= -this.range) {
                    this.pZ = 0;
                    this.pY = 0;
                }
            }
        } else if (facing == Direction.EAST) {
            ++this.pY;
            if (this.pY == 5) {
                this.pY = 0;
                ++this.pZ;
                if (this.pZ >= this.range) {
                    this.pZ = 0;
                    this.pY = 0;
                }
            }
        }
    }

    private boolean canWork() {
        if (this.needRedstone) {
            return (Boolean)this.m_58900_().m_61143_((Property)CocoaFarmerBlock.POWERED) != false;
        }
        if (!this.needRedstone) {
            return true;
        }
        return true;
    }

    private void rangeUpgrade() {
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CocoaFarmerBlock.f_54117_);
        boolean ironUpgrade = this.getUpgrade((TagKey<Item>)LibTags.Items.IRON_RANGE_UPGRADE);
        boolean goldUpgrade = this.getUpgrade((TagKey<Item>)LibTags.Items.GOLD_RANGE_UPGRADE);
        boolean diamondUpgrade = this.getUpgrade((TagKey<Item>)LibTags.Items.DIAMOND_RANGE_UPGRADE);
        if (ironUpgrade) {
            if (facing == Direction.NORTH) {
                this.x = this.m_58899_().m_123341_() - 1;
                this.z = this.m_58899_().m_123343_() - 2;
                this.range = 3;
            } else if (facing == Direction.SOUTH) {
                this.x = this.m_58899_().m_123341_() + 1;
                this.z = this.m_58899_().m_123343_() + 2;
                this.range = 3;
            } else if (facing == Direction.WEST) {
                this.x = this.m_58899_().m_123341_() - 2;
                this.z = this.m_58899_().m_123343_() + 1;
                this.range = 3;
            } else if (facing == Direction.EAST) {
                this.x = this.m_58899_().m_123341_() + 2;
                this.z = this.m_58899_().m_123343_() - 1;
                this.range = 3;
            }
        } else if (goldUpgrade) {
            if (facing == Direction.NORTH) {
                this.x = this.m_58899_().m_123341_() - 2;
                this.z = this.m_58899_().m_123343_() - 2;
                this.range = 5;
            } else if (facing == Direction.SOUTH) {
                this.x = this.m_58899_().m_123341_() + 2;
                this.z = this.m_58899_().m_123343_() + 2;
                this.range = 5;
            } else if (facing == Direction.WEST) {
                this.x = this.m_58899_().m_123341_() - 2;
                this.z = this.m_58899_().m_123343_() + 2;
                this.range = 5;
            } else if (facing == Direction.EAST) {
                this.x = this.m_58899_().m_123341_() + 2;
                this.z = this.m_58899_().m_123343_() - 2;
                this.range = 5;
            }
        } else if (diamondUpgrade) {
            if (facing == Direction.NORTH) {
                this.x = this.m_58899_().m_123341_() - 3;
                this.z = this.m_58899_().m_123343_() - 2;
                this.range = 7;
            } else if (facing == Direction.SOUTH) {
                this.x = this.m_58899_().m_123341_() + 3;
                this.z = this.m_58899_().m_123343_() + 2;
                this.range = 7;
            } else if (facing == Direction.WEST) {
                this.x = this.m_58899_().m_123341_() - 2;
                this.z = this.m_58899_().m_123343_() + 3;
                this.range = 7;
            } else if (facing == Direction.EAST) {
                this.x = this.m_58899_().m_123341_() + 2;
                this.z = this.m_58899_().m_123343_() - 3;
                this.range = 7;
            }
        } else if (facing == Direction.NORTH) {
            this.x = this.m_58899_().m_123341_();
            this.z = this.m_58899_().m_123343_() - 2;
            this.range = 1;
        } else if (facing == Direction.SOUTH) {
            this.x = this.m_58899_().m_123341_();
            this.z = this.m_58899_().m_123343_() + 2;
            this.range = 1;
        } else if (facing == Direction.WEST) {
            this.x = this.m_58899_().m_123341_() - 2;
            this.z = this.m_58899_().m_123343_();
            this.range = 1;
        } else if (facing == Direction.EAST) {
            this.x = this.m_58899_().m_123341_() + 2;
            this.z = this.m_58899_().m_123343_();
            this.range = 1;
        }
    }

    private boolean destroyBlock(BlockPos pos, boolean dropBlock) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        if (this.getDestBlock(state)) {
            if (!this.f_58857_.f_46443_) {
                if (this.pickupDrops) {
                    this.collectDrops(this.f_58857_, this.itemStorage, pos, 0, 9);
                    this.f_58857_.m_46961_(pos, dropBlock);
                    this.consumeEnergy(this.energyStorage, (Integer)FarmingConfig.COCOA_BEANS_FARMER_USEPERTICK.get());
                    return true;
                }
                if (!this.pickupDrops) {
                    this.f_58857_.m_46961_(pos, true);
                    this.consumeEnergy(this.energyStorage, (Integer)FarmingConfig.COCOA_BEANS_FARMER_USEPERTICK.get());
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean placeBlock(BlockPos pos) {
        Item item;
        int slot = this.getSlot(this.itemStorage, 8);
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CocoaFarmerBlock.f_54117_);
        if (facing == Direction.NORTH) {
            this.facingPos = pos.m_5484_(Direction.NORTH, 1);
        } else if (facing == Direction.SOUTH) {
            this.facingPos = pos.m_5484_(Direction.SOUTH, 1);
        } else if (facing == Direction.WEST) {
            this.facingPos = pos.m_5484_(Direction.WEST, 1);
        } else if (facing == Direction.EAST) {
            this.facingPos = pos.m_5484_(Direction.EAST, 1);
        }
        BlockState state = this.f_58857_.m_8055_(pos);
        BlockState facingState = this.f_58857_.m_8055_(this.facingPos);
        if (state.m_60734_() == Blocks.f_50262_) {
            return false;
        }
        if (facingState.m_60713_(Blocks.f_50002_) && (item = this.getStackInSlot(this.itemStorage, slot).m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (!this.f_58857_.f_46443_ && blockItem.m_5456_() == Items.f_42533_) {
                Block block = blockItem.m_40614_();
                this.f_58857_.m_7731_(pos, (BlockState)block.m_49966_().m_61124_((Property)CocoaBlock.f_54117_, (Comparable)((Direction)this.m_58900_().m_61143_((Property)CocoaFarmerBlock.f_54117_))), 3);
                this.f_58857_.m_5594_(null, pos, SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.consumeStack(this.itemStorage, slot, 1);
                this.consumeEnergy(this.energyStorage, (Integer)FarmingConfig.COCOA_BEANS_FARMER_USEPERTICK.get());
            }
        }
        return false;
    }

    private boolean getDestBlock(BlockState state) {
        return state.m_60734_() == Blocks.f_50262_ && (Integer)state.m_61143_((Property)BlockStateProperties.f_61406_) == 2;
    }

    public boolean isValidBlock(ItemStack stack) {
        return stack.m_150930_(Items.f_42533_);
    }

    public boolean getUpgrade(TagKey<Item> upgrade) {
        return this.getUpgrade(this.upgradeItemStorage, upgrade, 0, 2);
    }

    protected ItemStackHandler itemStorage() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                CocoaFarmerBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return CocoaFarmerBE.this.isValidBlock(stack);
            }
        };
    }

    protected ItemStackHandler upgradeItemStorage() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                CocoaFarmerBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return CocoaFarmerBE.this.isValidUpgrade(stack);
            }
        };
    }

    protected IItemHandler createCombinedItemHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemStorage, this.upgradeItemStorage}){};
    }

    protected ModEnergyStorage createEnergy() {
        return new ModEnergyStorage(true, (Integer)FarmingConfig.COCOA_BEANS_FARMER_CAPACITY.get(), (Integer)FarmingConfig.COCOA_BEANS_FARMER_USEPERTICK.get() * 2){

            protected void onEnergyChanged() {
                boolean newHasPower = CocoaFarmerBE.this.hasPowerToWork(CocoaFarmerBE.this.energyStorage, (Integer)FarmingConfig.COCOA_BEANS_FARMER_USEPERTICK.get());
                if (newHasPower) {
                    CocoaFarmerBE.this.f_58857_.m_7260_(CocoaFarmerBE.this.f_58858_, CocoaFarmerBE.this.m_58900_(), CocoaFarmerBE.this.m_58900_(), 3);
                }
                CocoaFarmerBE.this.m_6596_();
            }
        };
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                this.upgradeItemHandler.cast();
                return this.combinedItemHandler.cast();
            }
            return this.itemStorageHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

