/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.blockentity;

import com.the_millman.farmingutils.core.init.BlockEntityInit;
import com.the_millman.farmingutils.core.tags.ModItemTags;
import com.the_millman.farmingutils.core.util.FarmingConfig;
import com.the_millman.themillmanlib.common.blockentity.ItemEnergyBlockEntity;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import com.the_millman.themillmanlib.core.util.ModItemHandlerHelp;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class ComposterBE
extends ItemEnergyBlockEntity {
    int tick;
    boolean initialized = false;

    public ComposterBE(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.COMPOSTER.get(), pWorldPosition, pBlockState);
    }

    protected void init() {
        this.initialized = true;
        this.tick = 0;
    }

    public void tickServer() {
        if (!this.initialized) {
            this.init();
        }
        if (this.hasPowerToWork(this.energyStorage, (Boolean)FarmingConfig.FARMERS_NEEDS_ENERGY.get(), (Integer)FarmingConfig.COMPOSTER_USEPERTICK.get())) {
            ItemStack stack = this.getStackInSlot(this.itemStorage, 0);
            if (stack.m_204117_(ModItemTags.COMPOSTER_ITEMS) && stack.m_41613_() >= 4) {
                if (this.getStackInSlot(this.upgradeItemStorage, 0).m_41613_() < 64) {
                    ++this.tick;
                    if (this.tick >= (Integer)FarmingConfig.COMPOSTER_TICK.get()) {
                        this.tick = 0;
                        this.work();
                    }
                }
            } else if (this.getStackInSlot(this.itemStorage, 0).m_41619_() && this.tick > 0) {
                --this.tick;
            }
        }
    }

    private void work() {
        if (!this.f_58857_.m_5776_()) {
            ItemStack bonemeal = ModItemHandlerHelp.insertItemStacked((IItemHandler)this.upgradeItemStorage, (ItemStack)new ItemStack((ItemLike)Items.f_42499_, 1), (int)0, (int)1, (boolean)false);
            this.consumeStack(this.itemStorage, 0, 4);
            this.consumeEnergy(this.energyStorage, (Integer)FarmingConfig.COMPOSTER_USEPERTICK.get());
        }
    }

    public int getProgress() {
        return this.tick;
    }

    public int getMaxProgress() {
        return (Integer)FarmingConfig.COMPOSTER_TICK.get();
    }

    public boolean isValidBlock(ItemStack stack) {
        return false;
    }

    protected ItemStackHandler itemStorage() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                ComposterBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return true;
            }
        };
    }

    protected ItemStackHandler upgradeItemStorage() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                ComposterBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return true;
            }
        };
    }

    protected IItemHandler createCombinedItemHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemStorage, this.upgradeItemStorage}){

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                int index = this.getIndexForSlot(slot);
                if (this.getHandlerFromIndex(index) == ComposterBE.this.upgradeItemStorage) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    protected ModEnergyStorage createEnergy() {
        return new ModEnergyStorage(true, (Integer)FarmingConfig.COMPOSTER_CAPACITY.get(), (Integer)FarmingConfig.COMPOSTER_USEPERTICK.get() * 2){

            protected void onEnergyChanged() {
                boolean newHasPower = ComposterBE.this.hasPowerToWork(ComposterBE.this.energyStorage, (Integer)FarmingConfig.COMPOSTER_USEPERTICK.get());
                if (newHasPower) {
                    ComposterBE.this.f_58857_.m_7260_(ComposterBE.this.f_58858_, ComposterBE.this.m_58900_(), ComposterBE.this.m_58900_(), 3);
                }
                ComposterBE.this.m_6596_();
            }
        };
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.combinedItemHandler.cast();
            }
            if (side == Direction.DOWN) {
                return this.upgradeItemHandler.cast();
            }
            return this.itemStorageHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

