/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.blockentity;

import com.the_millman.farmingutils.common.blocks.CropFarmerBlock;
import com.the_millman.farmingutils.core.init.BlockEntityInit;
import com.the_millman.farmingutils.core.tags.ModBlockTags;
import com.the_millman.farmingutils.core.util.FarmingConfig;
import com.the_millman.themillmanlib.common.blockentity.ItemEnergyBlockEntity;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import com.the_millman.themillmanlib.core.util.LibTags;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class CropFarmerBE
extends ItemEnergyBlockEntity {
    private final int UP_SLOT_MIN = 0;
    private final int UP_SLOT_MAX = 2;
    private int tick;
    boolean initialized = false;
    boolean needRedstone = false;
    boolean pickupDrops = true;

    public CropFarmerBE(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.CROP_FARMER.get(), pWorldPosition, pBlockState);
    }

    protected void init() {
        this.initialized = true;
        this.x = this.m_58899_().m_123341_() - 1;
        this.y = this.m_58899_().m_123342_();
        this.z = this.m_58899_().m_123343_() - 1;
        this.tick = 0;
        this.pX = 0;
        this.pZ = 0;
        this.range = 3;
        this.needRedstone = false;
        this.pickupDrops = true;
    }

    public void tickServer() {
        if (!this.initialized) {
            this.init();
        }
        if (this.hasPowerToWork(this.energyStorage, (Boolean)FarmingConfig.FARMERS_NEEDS_ENERGY.get(), (Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get())) {
            ++this.tick;
            if (this.tick == (Integer)FarmingConfig.CROP_FARMER_TICK.get()) {
                this.tick = 0;
                this.needRedstone = this.getUpgrade((TagKey<Item>)LibTags.Items.REDSTONE_UPGRADE);
                if (this.canWork()) {
                    this.upgradeSlot();
                    BlockPos posToBreak = new BlockPos(this.x + this.pX, this.y, this.z + this.pZ);
                    this.destroyBlock(posToBreak, false);
                    this.placeBlock(posToBreak);
                    this.m_6596_();
                    this.posState();
                }
            }
        }
    }

    private boolean canWork() {
        if (this.needRedstone) {
            return (Boolean)this.m_58900_().m_61143_((Property)CropFarmerBlock.POWERED) != false;
        }
        if (!this.needRedstone) {
            return true;
        }
        return true;
    }

    private void upgradeSlot() {
        this.rangeSlot();
        this.pickupDrops = !this.getUpgrade((TagKey<Item>)LibTags.Items.DROP_UPGRADE);
    }

    private void rangeSlot() {
        boolean ironUpgrade = this.getUpgrade((TagKey<Item>)LibTags.Items.IRON_RANGE_UPGRADE);
        boolean goldUpgrade = this.getUpgrade((TagKey<Item>)LibTags.Items.GOLD_RANGE_UPGRADE);
        boolean diamondUpgrade = this.getUpgrade((TagKey<Item>)LibTags.Items.DIAMOND_RANGE_UPGRADE);
        if (ironUpgrade) {
            this.x = this.m_58899_().m_123341_() - 2;
            this.z = this.m_58899_().m_123343_() - 2;
            this.range = 5;
        } else if (goldUpgrade) {
            this.x = this.m_58899_().m_123341_() - 3;
            this.z = this.m_58899_().m_123343_() - 3;
            this.range = 7;
        } else if (diamondUpgrade) {
            this.x = this.m_58899_().m_123341_() - 4;
            this.z = this.m_58899_().m_123343_() - 4;
            this.range = 9;
        } else {
            this.x = this.m_58899_().m_123341_() - 1;
            this.z = this.m_58899_().m_123343_() - 1;
            this.range = 3;
        }
    }

    private boolean destroyBlock(BlockPos pos, boolean dropBlock) {
        BlockState state = this.f_58857_.m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        if (this.testBlock(state)) {
            if (!this.f_58857_.f_46443_) {
                if (this.pickupDrops) {
                    this.collectDrops(this.f_58857_, this.itemStorage, pos, 0, 18);
                    this.f_58857_.m_46961_(pos, dropBlock);
                    this.consumeEnergy(this.energyStorage, (Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get());
                    return true;
                }
                if (!this.pickupDrops) {
                    this.f_58857_.m_46961_(pos, true);
                    this.consumeEnergy(this.energyStorage, (Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get());
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private boolean placeBlock(BlockPos pos) {
        Item item;
        int slot = this.getSlot(this.itemStorage, 17);
        BlockPos posY = pos.m_7495_();
        BlockState state = this.f_58857_.m_8055_(pos);
        BlockState yState = this.f_58857_.m_8055_(posY);
        if (state.m_60734_() instanceof CropBlock) {
            return false;
        }
        if (yState.m_60734_() instanceof FarmBlock && this.isValidBlock(this.getStackInSlot(this.itemStorage, slot)) && (item = this.getStackInSlot(this.itemStorage, slot).m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (!this.f_58857_.f_46443_) {
                Block block = blockItem.m_40614_();
                this.f_58857_.m_7731_(pos, block.m_49966_(), 3);
                this.f_58857_.m_5594_(null, pos, SoundEvents.f_11839_, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.consumeStack(this.itemStorage, slot, 1);
                this.consumeEnergy(this.energyStorage, (Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get());
            }
        }
        return false;
    }

    private boolean getDestBlock(BlockState state) {
        if (state.m_204336_(ModBlockTags.AGE_3_CROPS) && (Integer)state.m_61143_((Property)BlockStateProperties.f_61407_) == 3) {
            return true;
        }
        if (!state.m_204336_(ModBlockTags.AGE_3_CROPS) && state.m_60734_() instanceof IPlantable && state.m_60734_() instanceof CropBlock) {
            return (Integer)state.m_61143_((Property)CropBlock.f_52244_) == 7;
        }
        return false;
    }

    private boolean testBlock(BlockState state) {
        if (state.m_60734_() instanceof IPlantable) {
            IntegerProperty AGE_3 = BlockStateProperties.f_61407_;
            if (state.m_61138_((Property)AGE_3) && (Integer)state.m_61143_((Property)AGE_3) == 3) {
                return true;
            }
            IntegerProperty AGE_7 = BlockStateProperties.f_61409_;
            if (state.m_61138_((Property)AGE_7) && (Integer)state.m_61143_((Property)AGE_7) == 7) {
                return true;
            }
        }
        return false;
    }

    public boolean isValidBlock(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ItemNameBlockItem) {
            ItemNameBlockItem blockItem = (ItemNameBlockItem)item;
            return blockItem.m_40614_() instanceof CropBlock;
        }
        return false;
    }

    public boolean getUpgrade(TagKey<Item> upgrade) {
        return this.getUpgrade(this.upgradeItemStorage, upgrade, 0, 2);
    }

    protected ItemStackHandler itemStorage() {
        return new ItemStackHandler(18){

            protected void onContentsChanged(int slot) {
                CropFarmerBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return !CropFarmerBE.this.isValidUpgrade(stack);
            }
        };
    }

    protected ItemStackHandler upgradeItemStorage() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                CropFarmerBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return CropFarmerBE.this.isValidUpgrade(stack);
            }
        };
    }

    protected IItemHandler createCombinedItemHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemStorage, this.upgradeItemStorage}){};
    }

    protected ModEnergyStorage createEnergy() {
        return new ModEnergyStorage(true, (Integer)FarmingConfig.CROP_FARMER_CAPACITY.get(), (Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get() * 2){

            protected void onEnergyChanged() {
                boolean newHasPower = CropFarmerBE.this.hasPowerToWork(CropFarmerBE.this.energyStorage, (Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get());
                if (newHasPower) {
                    CropFarmerBE.this.f_58857_.m_7260_(CropFarmerBE.this.f_58858_, CropFarmerBE.this.m_58900_(), CropFarmerBE.this.m_58900_(), 3);
                }
                CropFarmerBE.this.m_6596_();
            }
        };
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                this.upgradeItemHandler.cast();
                return this.combinedItemHandler.cast();
            }
            return this.itemStorageHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

