/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.blockentity;

import com.the_millman.farmingutils.common.blocks.InternalFarmerBlock;
import com.the_millman.farmingutils.common.recipes.InternalFarmerRecipe;
import com.the_millman.farmingutils.core.init.BlockEntityInit;
import com.the_millman.farmingutils.core.networking.FluidSyncS2CPacket;
import com.the_millman.farmingutils.core.networking.ItemStackSyncS2CPacket2;
import com.the_millman.farmingutils.core.networking.ModMessages;
import com.the_millman.farmingutils.core.util.FarmingConfig;
import com.the_millman.themillmanlib.common.blockentity.ItemEnergyFluidBlockEntity;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import com.the_millman.themillmanlib.core.util.BlockUtils;
import com.the_millman.themillmanlib.core.util.LibTags;
import com.the_millman.themillmanlib.core.util.ModItemHandlerHelp;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class InternalFarmerBE
extends ItemEnergyFluidBlockEntity {
    private final int UP_SLOT_MIN = 0;
    private final int UP_SLOT_MAX = 2;
    private int tick;
    private int growthStage;
    private int maxGrowthStage = 5;
    boolean initialized = false;
    BlockPos pos;

    public InternalFarmerBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.INTERNAL_FARMER.get(), pPos, pBlockState);
    }

    protected void init() {
        this.initialized = true;
        this.tick = 0;
        this.resetGrowthStage();
        this.needRedstone = false;
        this.pos = new BlockPos(this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
    }

    public void tickServer(InternalFarmerBE pEntity) {
        if (!this.initialized) {
            this.init();
        }
        if (this.getStackInSlot(this.itemStorage, 11).m_41613_() < 16) {
            this.transferItemFluidToFluidTank(this.itemStorage, this.fluidStorage, 10, 11);
            this.m_6596_();
        }
        if (this.hasPowerToWork(this.energyStorage, (Integer)FarmingConfig.INTERNAL_FARMER_USEPERTICK.get()) && this.getFluidAmount(this.fluidStorage) >= 100) {
            ++this.tick;
            if (this.tick >= (Integer)FarmingConfig.INTERNAL_FARMER_TICK.get()) {
                this.tick = 0;
                this.needRedstone = this.getUpgrade((TagKey<Item>)LibTags.Items.REDSTONE_UPGRADE);
                if (this.canWork()) {
                    this.updateGrowthStage();
                    if (this.growthStage >= this.maxGrowthStage) {
                        this.resetGrowthStage();
                        this.craftItem(pEntity);
                        this.m_6596_();
                    }
                }
            }
        }
    }

    private void craftItem(InternalFarmerBE pEntity) {
        Level level = pEntity.f_58857_;
        SimpleContainer inventory = this.setInventory();
        Optional recipe = level.m_7465_().m_44015_((RecipeType)InternalFarmerRecipe.Type.INSTANCE, (Container)inventory, level);
        if (this.hasRecipe(pEntity) && !level.m_5776_()) {
            ItemStack recipeOutput = new ItemStack((ItemLike)((InternalFarmerRecipe)recipe.get()).m_8043_().m_41720_(), ((InternalFarmerRecipe)recipe.get()).m_8043_().m_41613_());
            this.drain(this.fluidStorage, ((InternalFarmerRecipe)recipe.get()).getFluidStack().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.consumeEnergy(this.energyStorage, (Integer)FarmingConfig.INTERNAL_FARMER_USEPERTICK.get());
            ItemStack result = ModItemHandlerHelp.insertItemStacked((IItemHandler)pEntity.itemStorage, (ItemStack)recipeOutput, (int)0, (int)9, (boolean)false);
            if (!result.m_41619_()) {
                BlockUtils.spawnItemStack((ItemStack)result, (Level)level, (BlockPos)pEntity.pos.m_7494_());
            }
        }
        pEntity.resetGrowthStage();
    }

    private boolean hasRecipe(InternalFarmerBE blockEntity) {
        SimpleContainer inventory = this.setInventory();
        Optional recipe = this.f_58857_.m_7465_().m_44015_((RecipeType)InternalFarmerRecipe.Type.INSTANCE, (Container)inventory, this.f_58857_);
        return recipe.isPresent() && this.hasCorrectFluidInTank(blockEntity, recipe) && this.hasCorrectFluidAmountInTank(blockEntity, recipe);
    }

    private boolean hasCorrectFluidAmountInTank(InternalFarmerBE entity, Optional<InternalFarmerRecipe> recipe) {
        return this.getFluidAmount(this.fluidStorage) >= recipe.get().getFluidStack().getAmount();
    }

    private boolean hasCorrectFluidInTank(InternalFarmerBE entity, Optional<InternalFarmerRecipe> recipe) {
        return recipe.get().getFluidStack().equals((Object)this.getFluidStack());
    }

    private boolean canWork() {
        if (this.needRedstone) {
            return (Boolean)this.m_58900_().m_61143_((Property)InternalFarmerBlock.POWERED) != false;
        }
        if (!this.needRedstone) {
            return true;
        }
        return true;
    }

    public float getScaledProgress() {
        float standardSize = 1.0f;
        int progess = this.growthStage;
        int maxProgress = this.maxGrowthStage;
        return maxProgress != 0 && progess != 0 ? (float)progess * standardSize / (float)maxProgress : 0.0f;
    }

    public ItemStack getRenderStack() {
        return this.getStackInSlot(this.itemStorage, 9);
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemStorage.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public void setFluid(FluidStack fluidStack) {
        this.setFluid(this.fluidStorage, fluidStack);
    }

    public boolean isValidBlock(ItemStack stack) {
        return false;
    }

    public boolean getUpgrade(TagKey<Item> upgrade) {
        return this.getUpgrade(this.upgradeItemStorage, upgrade, 0, 2);
    }

    protected ItemStackHandler itemStorage() {
        return new ItemStackHandler(12){

            protected void onContentsChanged(int slot) {
                InternalFarmerBE.this.m_6596_();
                if (!InternalFarmerBE.this.f_58857_.m_5776_()) {
                    ModMessages.sendToClients(new ItemStackSyncS2CPacket2(this, InternalFarmerBE.this.f_58858_));
                }
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot >= 0 && slot <= 8) {
                    return !stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() && !stack.m_204117_(LibTags.Items.UPGRADES);
                }
                if (slot == 9) {
                    return !stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
                }
                if (slot == 10 || slot == 11) {
                    return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
                }
                return false;
            }
        };
    }

    protected ItemStackHandler upgradeItemStorage() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                InternalFarmerBE.this.m_6596_();
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return stack.m_204117_(LibTags.Items.REDSTONE_UPGRADE);
            }
        };
    }

    protected IItemHandler createCombinedItemHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemStorage, this.upgradeItemStorage}){};
    }

    protected ModEnergyStorage createEnergy() {
        return new ModEnergyStorage(true, (Integer)FarmingConfig.INTERNAL_FARMER_CAPACITY.get(), (Integer)FarmingConfig.INTERNAL_FARMER_USEPERTICK.get() * 2){

            protected void onEnergyChanged() {
                boolean newHasPower = InternalFarmerBE.this.hasPowerToWork(InternalFarmerBE.this.energyStorage, (Integer)FarmingConfig.INTERNAL_FARMER_USEPERTICK.get());
                if (newHasPower) {
                    InternalFarmerBE.this.f_58857_.m_7260_(InternalFarmerBE.this.f_58858_, InternalFarmerBE.this.m_58900_(), InternalFarmerBE.this.m_58900_(), 3);
                }
                InternalFarmerBE.this.m_6596_();
            }
        };
    }

    protected FluidTank fluidStorage() {
        return new FluidTank((Integer)FarmingConfig.INTERNAL_FARMER_FLUID_CAPACITY.get()){

            protected void onContentsChanged() {
                InternalFarmerBE.this.m_6596_();
                if (!InternalFarmerBE.this.f_58857_.m_5776_()) {
                    ModMessages.sendToClients(new FluidSyncS2CPacket(this.fluid, InternalFarmerBE.this.f_58858_));
                }
            }

            public boolean isFluidValid(FluidStack stack) {
                return stack.isFluidEqual(InternalFarmerBE.this.getFluidStack()) || InternalFarmerBE.this.fluidStorage.isEmpty();
            }
        };
    }

    private void resetGrowthStage() {
        this.growthStage = 1;
    }

    private void updateGrowthStage() {
        ++this.growthStage;
    }

    public void setGrowthStage(int growthStage) {
        this.growthStage = growthStage;
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128405_("growth_stage", this.growthStage);
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.growthStage = pTag.m_128451_("growth_stage");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                this.upgradeItemHandler.cast();
                return this.combinedItemHandler.cast();
            }
            return this.itemStorageHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(pkt.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }
}

