/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.blockentity;

import com.the_millman.farmingutils.core.init.BlockEntityInit;
import com.the_millman.farmingutils.core.util.FarmingConfig;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class TestBE
extends BlockEntity {
    public static final int INPUT_SLOTS = 18;
    public static final int UPGRADE_SLOTS = 3;
    private int tick;
    boolean initialized = false;
    boolean needRedstone = false;
    boolean pickupDrops = true;
    private final ItemStackHandler inputItems = this.createInputItemHandler();
    private final LazyOptional<IItemHandler> inputItemHandler = LazyOptional.of(() -> this.inputItems);
    private final ItemStackHandler upgradeItems = this.createUpgradeItemHandler();
    private final LazyOptional<IItemHandler> upgradeItemHandler = LazyOptional.of(() -> this.upgradeItems);
    private final LazyOptional<IItemHandler> combinedItemHandler = LazyOptional.of(this::createCombinedItemHandler);
    private final ModEnergyStorage energy = this.createEnergyStorage();
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> this.energy);

    public TestBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.CROP_FARMER.get(), pPos, pBlockState);
    }

    @Nonnull
    private ItemStackHandler createInputItemHandler() {
        return new ItemStackHandler(18){

            protected void onContentsChanged(int slot) {
                TestBE.this.m_6596_();
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }
        };
    }

    @Nonnull
    private ItemStackHandler createUpgradeItemHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                TestBE.this.m_6596_();
            }
        };
    }

    @Nonnull
    private IItemHandler createCombinedItemHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputItems, this.upgradeItems}){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                return stack;
            }
        };
    }

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(true, (Integer)FarmingConfig.CROP_FARMER_CAPACITY.get(), (Integer)FarmingConfig.CROP_FARMER_USEPERTICK.get() * 2){

            protected void onEnergyChanged() {
                TestBE.this.m_6596_();
            }
        };
    }

    public void m_7651_() {
        super.m_7651_();
        this.inputItemHandler.invalidate();
        this.upgradeItemHandler.invalidate();
        this.combinedItemHandler.invalidate();
        this.energyHandler.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.inputItems.serializeNBT());
        tag.m_128365_("Energy", this.energy.serializeNBT());
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inputItems.deserializeNBT(tag.m_128469_("Inventory"));
        }
        if (tag.m_128441_("Energy")) {
            this.energy.deserializeNBT(tag.m_128423_("Energy"));
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == null) {
                return this.combinedItemHandler.cast();
            }
            if (side == Direction.DOWN) {
                return this.upgradeItemHandler.cast();
            }
            return this.inputItemHandler.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

