/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.the_millman.themillmanlib.core.util.FluidJsonUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class InternalFarmerRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<Ingredient> recipeItems;
    private final FluidStack fluidStack;

    public InternalFarmerRecipe(ResourceLocation id, ItemStack output, NonNullList<Ingredient> recipeItems, FluidStack fluidStack) {
        this.id = id;
        this.output = output;
        this.recipeItems = recipeItems;
        this.fluidStack = fluidStack;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        if (pLevel.m_5776_()) {
            return false;
        }
        return ((Ingredient)this.recipeItems.get(0)).test(pContainer.m_8020_(9));
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.recipeItems;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }

    public ItemStack assemble(SimpleContainer pContainer) {
        return this.output;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<InternalFarmerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("farmingutils", "internal_farmer");

        public InternalFarmerRecipe fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122780_((int)1, (Object)Ingredient.f_43901_);
            FluidStack fluidStack = FluidJsonUtil.readFluidStack((JsonObject)pSerializedRecipe.get("fluid").getAsJsonObject());
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43917_((JsonElement)ingredients.get(i)));
            }
            return new InternalFarmerRecipe(pRecipeId, output, (NonNullList<Ingredient>)inputs, fluidStack);
        }

        @Nullable
        public InternalFarmerRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            NonNullList inputs = NonNullList.m_122780_((int)pBuffer.readInt(), (Object)Ingredient.f_43901_);
            FluidStack fluidStack = pBuffer.readFluidStack();
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack output = pBuffer.m_130267_();
            return new InternalFarmerRecipe(pRecipeId, output, (NonNullList<Ingredient>)inputs, fluidStack);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, InternalFarmerRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.m_7527_().size());
            pBuffer.writeFluidStack(pRecipe.fluidStack);
            for (Ingredient ing : pRecipe.m_7527_()) {
                ing.m_43923_(pBuffer);
            }
            pBuffer.writeItemStack(pRecipe.m_8043_(), false);
        }
    }

    public static class Type
    implements RecipeType<InternalFarmerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "internal_farmer";

        private Type() {
        }
    }
}

