/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.farmingutils.data;

import com.the_millman.farmingutils.data.providers.ModBlockStateModelProvider;
import com.the_millman.farmingutils.data.providers.ModBlockTagsProvider;
import com.the_millman.farmingutils.data.providers.ModItemModelProvider;
import com.the_millman.farmingutils.data.providers.ModItemTagsProvider;
import com.the_millman.farmingutils.data.providers.ModRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="farmingutils", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        ModBlockTagsProvider blockTags = new ModBlockTagsProvider(packOutput, lookupProvider, event.getExistingFileHelper());
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(packOutput, lookupProvider, blockTags, event.getExistingFileHelper()));
        gen.addProvider(event.includeClient(), (DataProvider)new ModBlockStateModelProvider(packOutput, event.getExistingFileHelper()));
        gen.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, event.getExistingFileHelper()));
    }
}

