/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.themillmanlib.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.the_millman.themillmanlib.common.containers.ItemEnergyContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public abstract class ItemEnergyScreen<T extends ItemEnergyContainer>
extends AbstractContainerScreen<T> {
    public ItemEnergyScreen(T pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
    }

    private boolean isMouseAbove(int mouseX, int mouseY, int xLeft, int xRight, int yTop, int yBot) {
        return mouseX >= this.getGuiLeft() + xLeft && mouseX <= this.getGuiLeft() + xRight && mouseY >= this.getGuiTop() + yTop && mouseY <= this.getGuiTop() + yBot;
    }

    protected void renderEnergyLevel(PoseStack matrixStack, int mouseX, int mouseY) {
        this.renderEnergyTooltip(matrixStack, mouseX, mouseY, 7, 21, 17, 70, "themillmanlib.tooltip.energy", ((ItemEnergyContainer)this.f_97732_).getEnergy(), ((ItemEnergyContainer)this.f_97732_).getMaxEnergyStored());
    }

    protected void renderEnergyTooltip(PoseStack pPoseStack, int mouseX, int mouseY, int xLeft, int xRight, int yTop, int yBot, String sEnergy, int energy, int capacity) {
        if (this.isMouseAbove(mouseX, mouseY, xLeft, xRight, yTop, yBot)) {
            this.m_169388_(pPoseStack, this.getTooltips(sEnergy, energy, capacity), Optional.empty(), mouseX, mouseY);
        }
    }

    public List<Component> getTooltips(String sEnergy, int energy, int capacity) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        MutableComponent energyComponent = Component.m_237113_((String)(energy + "/" + capacity + " FE"));
        tooltip.add((Component)Component.m_237115_((String)sEnergy));
        tooltip.add((Component)energyComponent.m_130940_(ChatFormatting.GRAY));
        return tooltip;
    }

    protected void renderEnergyBar(PoseStack matrixStack, ResourceLocation overlay) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)overlay);
        int height = 52;
        int stored = (int)((float)height * ((float)((ItemEnergyContainer)this.f_97732_).getEnergy() / (float)((ItemEnergyContainer)this.f_97732_).getMaxEnergyStored()));
        int gL = this.getGuiLeft();
        int gT = this.getGuiTop();
        this.m_93228_(matrixStack, gL + 8, gT + 18, 71, stored + 1, 13, height);
    }
}

