/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.themillmanlib.common.blockentity;

import com.the_millman.themillmanlib.common.blockentity.interfaces.IEnergyStorageHelper;
import com.the_millman.themillmanlib.common.blockentity.interfaces.IItemStorageHelper;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ItemEnergyBlockEntity
extends BlockEntity
implements IEnergyStorageHelper,
IItemStorageHelper {
    protected final ItemStackHandler itemStorage = this.itemStorage();
    protected final LazyOptional<IItemHandler> itemStorageHandler = LazyOptional.of(() -> this.itemStorage);
    protected final ItemStackHandler upgradeItemStorage = this.upgradeItemStorage();
    protected final LazyOptional<IItemHandler> upgradeItemHandler = LazyOptional.of(() -> this.upgradeItemStorage);
    protected final LazyOptional<IItemHandler> combinedItemHandler = LazyOptional.of(this::createCombinedItemHandler);
    protected final ModEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    protected int x;
    protected int y;
    protected int z;
    protected int pX;
    protected int pZ;
    protected int range;

    public ItemEnergyBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    protected abstract void init();

    public abstract void tickServer();

    protected void posState() {
        ++this.pX;
        if (this.pX >= this.range) {
            this.pX = 0;
            ++this.pZ;
            if (this.pZ >= this.range) {
                this.pX = 0;
                this.pZ = 0;
            }
        }
    }

    @Override
    public abstract boolean isValidBlock(ItemStack var1);

    public void energyDebug(boolean debug) {
        ItemStack consumeItem;
        if (debug && (consumeItem = this.itemStorage.getStackInSlot(0)).m_41720_() == Items.f_42413_) {
            this.energyStorage.addEnergy(1000);
            consumeItem.m_41774_(1);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.itemStorageHandler.invalidate();
        this.upgradeItemHandler.invalidate();
        this.combinedItemHandler.invalidate();
        this.energyHandler.invalidate();
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("Inventory", (Tag)this.itemStorage.serializeNBT());
        tag.m_128365_("UpgradeInventory", (Tag)this.upgradeItemStorage.serializeNBT());
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.itemStorage.deserializeNBT(tag.m_128469_("Inventory"));
        }
        if (tag.m_128441_("UpgradeInventory")) {
            this.upgradeItemStorage.deserializeNBT(tag.m_128469_("UpgradeInventory"));
        }
        if (tag.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected abstract ItemStackHandler itemStorage();

    protected abstract ItemStackHandler upgradeItemStorage();

    protected abstract IItemHandler createCombinedItemHandler();

    protected abstract ModEnergyStorage createEnergy();
}

