/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.themillmanlib.common.blockentity;

import com.the_millman.themillmanlib.common.blockentity.interfaces.IEnergyStorageHelper;
import com.the_millman.themillmanlib.common.blockentity.interfaces.IFluidStorageHelper;
import com.the_millman.themillmanlib.common.blockentity.interfaces.IItemStorageHelper;
import com.the_millman.themillmanlib.core.energy.ModEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class ItemEnergyFluidBlockEntity
extends BlockEntity
implements IEnergyStorageHelper,
IItemStorageHelper,
IFluidStorageHelper {
    protected boolean needRedstone = false;
    protected final ItemStackHandler itemStorage = this.itemStorage();
    protected final LazyOptional<IItemHandler> itemStorageHandler = LazyOptional.of(() -> this.itemStorage);
    protected final ItemStackHandler upgradeItemStorage = this.upgradeItemStorage();
    protected final LazyOptional<IItemHandler> upgradeItemHandler = LazyOptional.of(() -> this.upgradeItemStorage);
    protected final LazyOptional<IItemHandler> combinedItemHandler = LazyOptional.of(this::createCombinedItemHandler);
    protected final ModEnergyStorage energyStorage = this.createEnergy();
    private final LazyOptional<IEnergyStorage> energyHandler = LazyOptional.of(() -> this.energyStorage);
    protected final FluidTank fluidStorage = this.fluidStorage();
    private LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.fluidStorage);

    public ItemEnergyFluidBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    protected abstract void init();

    public FluidStack getFluidStack() {
        return this.getFluidStack(this.fluidStorage);
    }

    @Override
    public abstract boolean isValidBlock(ItemStack var1);

    protected SimpleContainer setInventory() {
        int slots = this.itemStorage.getSlots();
        SimpleContainer inventory = new SimpleContainer(slots);
        for (int i = 0; i < slots; ++i) {
            inventory.m_6836_(i, this.itemStorage.getStackInSlot(i));
        }
        return inventory;
    }

    public void energyDebug(boolean debug) {
        ItemStack consumeItem;
        if (debug && (consumeItem = this.itemStorage.getStackInSlot(0)).m_41720_() == Items.f_42413_) {
            this.energyStorage.addEnergy(1000);
            consumeItem.m_41774_(1);
        }
    }

    public void m_7651_() {
        this.itemStorageHandler.invalidate();
        this.upgradeItemHandler.invalidate();
        this.combinedItemHandler.invalidate();
        this.energyHandler.invalidate();
        this.fluidHandler.invalidate();
        super.m_7651_();
    }

    public void onLoad() {
        this.fluidHandler = LazyOptional.of(() -> this.fluidStorage);
        super.onLoad();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemStorageHandler.invalidate();
        this.upgradeItemHandler.invalidate();
        this.combinedItemHandler.invalidate();
        this.energyHandler.invalidate();
        this.fluidHandler.invalidate();
    }

    public void m_142466_(CompoundTag pTag) {
        if (pTag.m_128441_("Inventory")) {
            this.itemStorage.deserializeNBT(pTag.m_128469_("Inventory"));
        }
        if (pTag.m_128441_("UpgradeInventory")) {
            this.upgradeItemStorage.deserializeNBT(pTag.m_128469_("UpgradeInventory"));
        }
        if (pTag.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(pTag.m_128423_("Energy"));
        }
        this.fluidStorage.readFromNBT(pTag);
        super.m_142466_(pTag);
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128365_("Inventory", (Tag)this.itemStorage.serializeNBT());
        pTag.m_128365_("UpgradeInventory", (Tag)this.upgradeItemStorage.serializeNBT());
        pTag.m_128365_("Energy", this.energyStorage.serializeNBT());
        pTag = this.fluidStorage.writeToNBT(pTag);
        CompoundTag infoTag = new CompoundTag();
        pTag.m_128365_("Info", (Tag)infoTag);
        super.m_183515_(pTag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected abstract ItemStackHandler itemStorage();

    protected abstract ItemStackHandler upgradeItemStorage();

    protected abstract IItemHandler createCombinedItemHandler();

    protected abstract ModEnergyStorage createEnergy();

    protected abstract FluidTank fluidStorage();
}

