/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.themillmanlib.common.blockentity.interfaces;

import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public interface IFluidStorageHelper {
    default public void setFluid(FluidTank fluidStorage, FluidStack fluidStack) {
        fluidStorage.setFluid(fluidStack);
    }

    default public FluidStack getFluidStack(FluidTank fluidStorage) {
        return fluidStorage.getFluid();
    }

    default public void drain(FluidTank fluidStorage, int maxDrain, IFluidHandler.FluidAction action) {
        fluidStorage.drain(maxDrain, action);
    }

    default public int getFluidAmount(FluidTank fluidStorage) {
        return fluidStorage.getFluidAmount();
    }

    default public void transferItemFluidToFluidTank(ItemStackHandler itemStorage, FluidTank fluidStorage, int slotI, int slotO) {
        itemStorage.getStackInSlot(slotI).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
            int drainAmount = Math.min(fluidStorage.getSpace(), 1000);
            FluidStack stack = handler.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
            if (fluidStorage.isFluidValid(stack)) {
                stack = handler.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                this.fillTankWithFluid(itemStorage, fluidStorage, stack, handler.getContainer(), slotI, slotO);
            }
        });
    }

    default public void fillTankWithFluid(ItemStackHandler itemStorage, FluidTank fluidStorage, FluidStack stack, ItemStack container, int slotI, int slotO) {
        fluidStorage.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        itemStorage.extractItem(slotI, 1, false);
        itemStorage.insertItem(slotO, container, false);
    }

    default public void transferItemFluidToFluidTank(ItemStackHandler itemStorage, FluidTank fluidStorage, int slot) {
        itemStorage.getStackInSlot(slot).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(handler -> {
            int drainAmount = Math.min(fluidStorage.getSpace(), 1000);
            FluidStack stack = handler.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
            if (fluidStorage.isFluidValid(stack)) {
                stack = handler.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                this.fillTankWithFluid(itemStorage, fluidStorage, stack, handler.getContainer(), slot);
            }
        });
    }

    default public void fillTankWithFluid(ItemStackHandler itemStorage, FluidTank fluidStorage, FluidStack stack, ItemStack container, int slot) {
        fluidStorage.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        itemStorage.extractItem(slot, 1, false);
        itemStorage.insertItem(slot, container, false);
    }
}

