/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.themillmanlib.common.blockentity.interfaces;

import com.the_millman.themillmanlib.common.items.UpgradeItem;
import com.the_millman.themillmanlib.core.util.BlockUtils;
import com.the_millman.themillmanlib.core.util.ModItemHandlerHelp;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public interface IItemStorageHelper {
    default public void collectDrops(Level level, ItemStackHandler itemStorage, BlockPos pos, int minSlot, int maxSlot) {
        if (!level.f_46443_) {
            for (ItemStack blockDrops : BlockUtils.getBlockDrops(level, pos)) {
                ItemStack result = ModItemHandlerHelp.insertItemStacked((IItemHandler)itemStorage, blockDrops, minSlot, maxSlot, false);
                if (result.m_41619_()) continue;
                BlockUtils.spawnItemStack(result, level, pos);
            }
        }
    }

    default public void collectDrops(Level level, ItemStackHandler itemStorage, BlockPos pos) {
        if (!level.f_46443_) {
            for (ItemStack blockDrops : BlockUtils.getBlockDrops(level, pos)) {
                ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)itemStorage, (ItemStack)blockDrops, (boolean)false);
                if (result.m_41619_()) continue;
                BlockUtils.spawnItemStack(result, level, pos);
            }
        }
    }

    default public boolean isValidUpgrade(ItemStack stack) {
        return stack.m_41720_() instanceof UpgradeItem;
    }

    default public boolean isValidUpgrade(ItemStack stack, TagKey<Item> tag) {
        return stack.m_204117_(tag);
    }

    default public void consumeStack(ItemStackHandler itemStorage, int slot, int consume) {
        ItemStack stack = itemStorage.getStackInSlot(slot);
        stack.m_41774_(consume);
    }

    default public ItemStack getStackInSlot(ItemStackHandler itemStorage, int slot) {
        return itemStorage.getStackInSlot(slot);
    }

    default public int getUpgradeSlot(ItemStackHandler itemStorage, ItemStack upgrade, int minSlot, int maxSlot) {
        for (int i = minSlot; i <= maxSlot; ++i) {
            ItemStack upgradeItem = this.getStackInSlot(itemStorage, i);
            if (upgradeItem != upgrade) continue;
            return i;
        }
        return 0;
    }

    default public int getUpgradeSlot(ItemStackHandler itemStorage, TagKey<Item> upgrade, int minSlot, int maxSlot) {
        for (int i = minSlot; i <= maxSlot; ++i) {
            ItemStack upgradeItem = this.getStackInSlot(itemStorage, i);
            if (!upgradeItem.m_204117_(upgrade)) continue;
            return i;
        }
        return 0;
    }

    default public boolean getUpgrade(ItemStackHandler itemStorage, TagKey<Item> upgrade, int minSlot, int maxSlot) {
        int slot = this.getUpgradeSlot(itemStorage, upgrade, minSlot, maxSlot);
        boolean isUpgrade = this.getStackInSlot(itemStorage, slot).m_204117_(upgrade);
        return isUpgrade;
    }

    default public int getSlot(ItemStackHandler itemStorage, int maxSlot) {
        for (int i = 0; i < maxSlot; ++i) {
            if (this.getStackInSlot(itemStorage, i).m_41619_() || this.getStackInSlot(itemStorage, i).m_41619_() || !this.isValidBlock(this.getStackInSlot(itemStorage, i))) continue;
            return i;
        }
        return maxSlot;
    }

    public boolean isValidBlock(ItemStack var1);

    default public void drops(Level level, BlockPos worldPosition, ItemStackHandler itemStorage) {
        SimpleContainer inventory = new SimpleContainer(itemStorage.getSlots());
        for (int i = 0; i < itemStorage.getSlots(); ++i) {
            inventory.m_6836_(i, itemStorage.getStackInSlot(i));
        }
        Containers.m_19002_((Level)level, (BlockPos)worldPosition, (Container)inventory);
    }
}

