/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.themillmanlib.common.containers;

import com.the_millman.themillmanlib.common.blockentity.ItemFluidBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class ItemFluidContainer
extends AbstractContainerMenu {
    protected ItemFluidBlockEntity blockEntity;
    protected Player playerEntity;
    protected IItemHandler playerInventory;
    protected FluidStack fluidStack;

    public ItemFluidContainer(MenuType<?> pMenuType, int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player) {
        super(pMenuType, windowId);
        BlockEntity entity = world.m_7702_(pos);
        this.blockEntity = (ItemFluidBlockEntity)entity;
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.fluidStack = this.blockEntity.getFluidStack();
    }

    protected int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    protected int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    protected void layoutPlayerInventorySlots(IItemHandler playerInventory, int leftCol, int topRow) {
        this.addSlotBox(playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    protected void layoutInventorySlots(IItemHandler handler, int x, int y, int slotRow, int slotColumn) {
        for (int row = 0; row < slotRow; ++row) {
            for (int column = 0; column < slotColumn; ++column) {
                this.m_38897_((Slot)new SlotItemHandler(handler, row * slotColumn + column, x + column * 18, y + row * 18));
            }
        }
    }

    protected void layoutUpgradeSlots(IItemHandler handler, int index, int x, int y, int slotColumn) {
        for (int column = 0; column < slotColumn; ++column) {
            this.m_38897_((Slot)new SlotItemHandler(handler, column + index, x, y + column * 18));
        }
    }

    public BlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluidStack = fluidStack;
    }

    public FluidStack getFluidStack() {
        return this.fluidStack;
    }
}

