/*
 * Decompiled with CFR 0.152.
 */
package com.the_millman.themillmanlib.core.data;

import com.the_millman.themillmanlib.core.data.providers.LibBlockTagsProvider;
import com.the_millman.themillmanlib.core.data.providers.LibItemModelProvider;
import com.the_millman.themillmanlib.core.data.providers.LibItemTagsProvider;
import com.the_millman.themillmanlib.core.data.providers.LibRecipesProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="themillmanlib", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    private DataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        LibBlockTagsProvider blockTags = new LibBlockTagsProvider(packOutput, lookupProvider, event.getExistingFileHelper());
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new LibItemTagsProvider(packOutput, lookupProvider, blockTags, event.getExistingFileHelper()));
        gen.addProvider(event.includeServer(), (DataProvider)new LibRecipesProvider(packOutput));
        gen.addProvider(event.includeClient(), (DataProvider)new LibItemModelProvider(packOutput, event.getExistingFileHelper()));
    }
}

