/*
 * Decompiled with CFR 0.152.
 */
package com.rosymaple.hitindication.capability.latesthits;

import com.rosymaple.hitindication.capability.latesthits.Hit;
import com.rosymaple.hitindication.capability.latesthits.Indicator;
import com.rosymaple.hitindication.config.HitIndicatorConfig;
import com.rosymaple.hitindication.networking.AddHitS2CPacket;
import com.rosymaple.hitindication.networking.ModPackets;
import com.rosymaple.hitindication.networking.TickHitsS2CPacket;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class LatestHits {
    public ArrayList<Hit> latestHits = new ArrayList();

    LatestHits() {
    }

    public void addHit(EntityPlayerMP player, EntityLivingBase damageSource, Indicator indicator, int damagePercent) {
        this.latestHits.add(new Hit(damageSource.field_70165_t, damageSource.field_70163_u, damageSource.field_70161_v, indicator, damagePercent));
        if (HitIndicatorConfig.MaxIndicatorCount > 0 && this.latestHits.size() > HitIndicatorConfig.MaxIndicatorCount) {
            this.latestHits.remove(0);
        }
        ModPackets.sendToPlayer(new AddHitS2CPacket(damageSource.field_70165_t, damageSource.field_70163_u, damageSource.field_70161_v, indicator.type, damagePercent), player);
    }

    public void tick(EntityPlayerMP player) {
        for (int i = this.latestHits.size() - 1; i >= 0; --i) {
            Hit hit = this.latestHits.get(i);
            hit.tick();
            if (!hit.expired()) continue;
            this.latestHits.remove(i);
        }
        ModPackets.sendToPlayer(new TickHitsS2CPacket(), player);
    }

    public static class LatestHitsNBTStorage
    implements Capability.IStorage<LatestHits> {
        @Nullable
        public NBTBase writeNBT(Capability<LatestHits> capability, LatestHits instance, EnumFacing side) {
            NBTTagList list = new NBTTagList();
            return list;
        }

        public void readNBT(Capability<LatestHits> capability, LatestHits instance, EnumFacing side, NBTBase nbt) {
        }
    }
}

