/*
 * Decompiled with CFR 0.152.
 */
package com.rosymaple.hitindication.config;

import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HitIndicatorConfig {
    private static Configuration config = null;
    public static final String CATEGORY_NAME_INDICATOR = "indicators";
    public static int MaxIndicatorCount;
    public static boolean DisplayHitsFromNegativePotions;
    public static int FadeRate;
    public static int IndicatorOpacity;
    public static boolean ShowBlueIndicators;
    public static boolean SizeDependsOnDamage;
    public static int IndicatorDefaultScale;

    public static void preInit() {
        File configFile = new File(Loader.instance().getConfigDir(), "HitIndication.cfg");
        config = new Configuration(configFile);
        HitIndicatorConfig.syncFromFiles();
    }

    public static Configuration getConfig() {
        return config;
    }

    public static void syncFromFiles() {
        HitIndicatorConfig.syncConfig(true, true);
    }

    public static void syncFromGui() {
        HitIndicatorConfig.syncConfig(false, true);
    }

    private static void syncConfig(boolean loadFromConfigFile, boolean readFromConfigFile) {
        if (loadFromConfigFile) {
            config.load();
        }
        Property maxIndicatorCount = config.get(CATEGORY_NAME_INDICATOR, "max_indicator_count", 0);
        maxIndicatorCount.setName("Max Indicator Count");
        maxIndicatorCount.setComment("Determines maximum indicator count shown on screen (0 = unlimited). Upon exceeding the oldest indicator will be removed.");
        maxIndicatorCount.setMinValue(0);
        Property displayHitsFromNegativePotions = config.get(CATEGORY_NAME_INDICATOR, "display_hits_from_negative_potions", true);
        displayHitsFromNegativePotions.setName("Display Hits From Non-Damaging Negative Potions");
        displayHitsFromNegativePotions.setComment("Shows red indicator when an entity hits the player with a non-damaging negative potion.");
        Property fadeRate = config.get(CATEGORY_NAME_INDICATOR, "fade_rate", 50);
        fadeRate.setName("Indicator Fade Rate (Ticks)");
        fadeRate.setComment("Amount of ticks after which indicator disappears.");
        fadeRate.setMinValue(0);
        Property indicatorOpacity = config.get(CATEGORY_NAME_INDICATOR, "indicator_opacity", 25);
        indicatorOpacity.setName("Indicator Opacity (0-100)");
        indicatorOpacity.setComment("Determines opacity of the indicators.");
        indicatorOpacity.setMinValue(0);
        indicatorOpacity.setMaxValue(100);
        Property indicatorDefaultScale = config.get(CATEGORY_NAME_INDICATOR, "indicator_default_scale", 25);
        indicatorDefaultScale.setName("Indicator Default Scale (0-100)");
        indicatorDefaultScale.setComment("Determines scale of indicators.");
        indicatorDefaultScale.setMinValue(0);
        indicatorDefaultScale.setMaxValue(100);
        Property displayBlueIndicators = config.get(CATEGORY_NAME_INDICATOR, "display_blue_indicators", true);
        displayBlueIndicators.setName("Show Block Indicator");
        displayBlueIndicators.setComment("Shows blue indicator when the player blocks incoming damage with a shield.\n");
        Property sizeDependsOnDamage = config.get(CATEGORY_NAME_INDICATOR, "size_depends_on_damage", false);
        sizeDependsOnDamage.setName("Heavy damage makes indicator larger");
        sizeDependsOnDamage.setComment("Any instance of damage that deals 30 percent or more of max health will result in larger indicators.");
        ArrayList<String> propertyOrderIndicators = new ArrayList<String>();
        propertyOrderIndicators.add(maxIndicatorCount.getName());
        propertyOrderIndicators.add(displayHitsFromNegativePotions.getName());
        propertyOrderIndicators.add(displayBlueIndicators.getName());
        propertyOrderIndicators.add(fadeRate.getName());
        propertyOrderIndicators.add(indicatorOpacity.getName());
        propertyOrderIndicators.add(indicatorDefaultScale.getName());
        propertyOrderIndicators.add(sizeDependsOnDamage.getName());
        config.setCategoryPropertyOrder(CATEGORY_NAME_INDICATOR, propertyOrderIndicators);
        if (readFromConfigFile) {
            MaxIndicatorCount = maxIndicatorCount.getInt();
            DisplayHitsFromNegativePotions = displayHitsFromNegativePotions.getBoolean();
            FadeRate = fadeRate.getInt();
            IndicatorOpacity = indicatorOpacity.getInt();
            ShowBlueIndicators = displayBlueIndicators.getBoolean();
            SizeDependsOnDamage = sizeDependsOnDamage.getBoolean();
            IndicatorDefaultScale = indicatorDefaultScale.getInt();
        }
        maxIndicatorCount.set(MaxIndicatorCount);
        displayHitsFromNegativePotions.set(DisplayHitsFromNegativePotions);
        fadeRate.set(FadeRate);
        indicatorOpacity.set(IndicatorOpacity);
        displayBlueIndicators.set(ShowBlueIndicators);
        indicatorDefaultScale.set(IndicatorDefaultScale);
        sizeDependsOnDamage.set(SizeDependsOnDamage);
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventBusSubscriber(modid="hitindication")
    public static class ConfigEventHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID() == "hitindication") {
                HitIndicatorConfig.syncFromGui();
            }
        }
    }
}

