/*
 * Decompiled with CFR 0.152.
 */
package com.rosymaple.hitindication.event;

import com.rosymaple.hitindication.capability.latesthits.Indicator;
import com.rosymaple.hitindication.capability.latesthits.LatestHits;
import com.rosymaple.hitindication.capability.latesthits.LatestHitsProvider;
import com.rosymaple.hitindication.config.HitIndicatorConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="hitindication")
public class HitEvents {
    @SubscribeEvent
    public static void onAttack(LivingDamageEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayerMP) || !(event.getSource().func_76346_g() instanceof EntityLivingBase) || event.getSource().func_76364_f() instanceof EntityPotion) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
        EntityLivingBase source = (EntityLivingBase)event.getSource().func_76346_g();
        int damagePercent = (int)Math.floor(event.getAmount() / player.func_110138_aP() * 100.0f);
        LatestHits hits = (LatestHits)player.getCapability(LatestHitsProvider.LATEST_HITS, null);
        if (hits == null) {
            return;
        }
        hits.addHit(player, source, Indicator.RED, damagePercent);
    }

    @SubscribeEvent
    public static void onBlock(LivingAttackEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayerMP) || !(event.getSource().func_76346_g() instanceof EntityLivingBase) || event.getSource().func_76364_f() instanceof EntityPotion) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
        EntityLivingBase source = (EntityLivingBase)event.getSource().func_76346_g();
        LatestHits hits = (LatestHits)player.getCapability(LatestHitsProvider.LATEST_HITS, null);
        if (hits == null) {
            return;
        }
        boolean playerIsBlocking = HitEvents.canBlockDamageSource(player, event.getSource());
        boolean shieldAboutToBreak = source.func_184614_ca().func_77973_b().canDisableShield(source.func_184614_ca(), player.func_184607_cu(), (EntityLivingBase)player, source);
        if (playerIsBlocking && HitIndicatorConfig.ShowBlueIndicators) {
            hits.addHit(player, source, Indicator.BLUE, shieldAboutToBreak ? 125 : 0);
        }
    }

    @SubscribeEvent
    public static void onPotion(ProjectileImpactEvent.Throwable event) {
        if (!(event.getThrowable().func_85052_h() instanceof EntityLivingBase && event.getThrowable().func_85052_h().func_130014_f_() instanceof WorldServer && event.getThrowable() instanceof EntityPotion)) {
            return;
        }
        AxisAlignedBB axisalignedbb = event.getThrowable().func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List list = event.getThrowable().field_70170_p.func_72872_a(EntityPlayerMP.class, axisalignedbb);
        EntityLivingBase source = event.getThrowable().func_85052_h();
        EntityPotion potion = (EntityPotion)event.getThrowable();
        boolean hasNegativeEffects = PotionUtils.func_185189_a((ItemStack)potion.func_184543_l()).stream().anyMatch(x -> x.func_188419_a().func_76398_f());
        boolean damagingPotion = PotionUtils.func_185189_a((ItemStack)potion.func_184543_l()).stream().anyMatch(x -> x.func_188419_a() == MobEffects.field_76436_u || x.func_188419_a() == MobEffects.field_76433_i || x.func_188419_a() == MobEffects.field_82731_v);
        int damagePercent = 0;
        Optional<PotionEffect> instantDamage = PotionUtils.func_185189_a((ItemStack)potion.func_184543_l()).stream().filter(x -> x.func_188419_a() == MobEffects.field_76433_i).findFirst();
        for (EntityPlayerMP player : list) {
            LatestHits hits;
            if (!player.func_184603_cC() || (hits = (LatestHits)player.getCapability(LatestHitsProvider.LATEST_HITS, null)) == null || !damagingPotion && (!hasNegativeEffects || !HitIndicatorConfig.DisplayHitsFromNegativePotions)) continue;
            if (instantDamage.isPresent()) {
                damagePercent = (int)Math.floor(HitEvents.applyPotionDamageCalculations(player, DamageSource.field_76376_m, 3 * (2 << instantDamage.get().func_76458_c())) / player.func_110138_aP() * 100.0f);
            }
            hits.addHit(player, source, Indicator.RED, damagePercent);
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (!(event.player instanceof EntityPlayerMP) || event.phase == TickEvent.Phase.END) {
            return;
        }
        LatestHits hits = (LatestHits)event.player.getCapability(LatestHitsProvider.LATEST_HITS, null);
        if (hits != null) {
            hits.tick((EntityPlayerMP)event.player);
        }
    }

    private static boolean canBlockDamageSource(EntityPlayerMP entity, DamageSource damageSourceIn) {
        Vec3d vec3d;
        if (!damageSourceIn.func_76363_c() && entity.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vec3d vec3d1 = entity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private static float applyPotionDamageCalculations(EntityPlayerMP player, DamageSource source, float damage) {
        if (source.func_151517_h()) {
            return damage;
        }
        if (player.func_70644_a(MobEffects.field_76429_m) && source != DamageSource.field_76380_i) {
            int i = (player.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1) * 5;
            int j = 25 - i;
            float f = damage * (float)j;
            damage = f / 25.0f;
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        int k = EnchantmentHelper.func_77508_a((Iterable)player.func_184193_aE(), (DamageSource)source);
        if (k > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)k);
        }
        return damage;
    }
}

