/*
 * Decompiled with CFR 0.152.
 */
package com.rosymaple.hitindication.event;

import com.rosymaple.hitindication.capability.latesthits.ClientLatestHits;
import com.rosymaple.hitindication.capability.latesthits.Hit;
import com.rosymaple.hitindication.capability.latesthits.Indicator;
import com.rosymaple.hitindication.config.HitIndicatorConfig;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="hitindication", value={Side.CLIENT})
public class RenderEvents {
    private static final ResourceLocation INDICATOR_RED = new ResourceLocation("hitindication", "textures/hit/indicator_red.png");
    private static final ResourceLocation INDICATOR_BLUE = new ResourceLocation("hitindication", "textures/hit/indicator_blue.png");
    private static final int textureWidth = 42;
    private static final int textureHeight = 13;

    @SubscribeEvent
    public static void onRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        TextureManager textureManager = mc.func_110434_K();
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        int screenMiddleX = scaledResolution.func_78326_a() / 2;
        int screenMiddleY = scaledResolution.func_78328_b() / 2;
        Vector2d lookVec = RenderEvents.getLookVec(mc.field_71439_g);
        Vector2d playerPos = new Vector2d(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70161_v);
        for (Hit hit : ClientLatestHits.latestHits) {
            RenderEvents.drawIndicator(hit, textureManager, screenMiddleX, screenMiddleY, playerPos, lookVec);
        }
    }

    private static void drawIndicator(Hit hit, TextureManager textureManager, int screenMiddleX, int screenMiddleY, Vector2d playerPos, Vector2d lookVec) {
        Vector3d sourceVec3d = hit.getLocation();
        Vector2d diff = new Vector2d(sourceVec3d.x - playerPos.x, sourceVec3d.z - playerPos.y);
        double angleBetween = RenderEvents.angleBetween(lookVec, diff);
        float opacity = hit.getLifeTime() >= 25 ? (float)HitIndicatorConfig.IndicatorOpacity : (float)(HitIndicatorConfig.IndicatorOpacity * hit.getLifeTime()) / 25.0f;
        opacity /= 100.0f;
        float defaultScale = 1.0f + (float)HitIndicatorConfig.IndicatorDefaultScale / 100.0f;
        int scaledTextureWidth = (int)Math.floor(42.0f * defaultScale);
        int scaledTextureHeight = (int)Math.floor(13.0f * defaultScale);
        if (HitIndicatorConfig.SizeDependsOnDamage) {
            float scale = MathHelper.func_76131_a((float)(hit.getDamagePercent() > 30 ? 1.0f + (float)hit.getDamagePercent() / 125.0f : 1.0f), (float)0.0f, (float)3.0f);
            scaledTextureWidth = (int)Math.floor((float)scaledTextureWidth * scale);
            scaledTextureHeight = (int)Math.floor((float)scaledTextureHeight * scale);
        }
        RenderEvents.bindIndicatorTexture(textureManager, hit.getIndicator());
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        GL11.glTranslatef((float)screenMiddleX, (float)screenMiddleY, (float)0.0f);
        GL11.glRotatef((float)((float)angleBetween), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-screenMiddleX), (float)(-screenMiddleY), (float)0.0f);
        Gui.func_146110_a((int)(screenMiddleX - scaledTextureWidth / 2), (int)(screenMiddleY - scaledTextureHeight / 2 - 30), (float)0.0f, (float)0.0f, (int)scaledTextureWidth, (int)scaledTextureHeight, (float)scaledTextureWidth, (float)scaledTextureHeight);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private static void bindIndicatorTexture(TextureManager textureManager, Indicator type) {
        switch (type) {
            case BLUE: {
                textureManager.func_110577_a(INDICATOR_BLUE);
                break;
            }
            default: {
                textureManager.func_110577_a(INDICATOR_RED);
            }
        }
    }

    private static double angleBetween(Vector2d first, Vector2d second) {
        double dot = first.x * second.x + first.y * second.y;
        double cross = first.x * second.y - second.x * first.y;
        double res = Math.atan2(cross, dot) * 180.0 / Math.PI;
        return res;
    }

    private static Vector2d getLookVec(EntityPlayerSP player) {
        return new Vector2d(-Math.sin((double)(-player.field_70177_z) * Math.PI / 180.0 - Math.PI), -Math.cos((double)(-player.field_70177_z) * Math.PI / 180.0 - Math.PI));
    }
}

