/*
 * Decompiled with CFR 0.152.
 */
package com.rosymaple.hitindication.networking;

import com.rosymaple.hitindication.capability.latesthits.ClientLatestHits;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class AddHitS2CPacket
implements IMessage {
    double x;
    double y;
    double z;
    int indicatorType;
    int damagePercent;

    public AddHitS2CPacket() {
    }

    public AddHitS2CPacket(double x, double y, double z, int indicatorType, int damagePercent) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.indicatorType = indicatorType;
        this.damagePercent = damagePercent;
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.indicatorType = buf.readInt();
        this.damagePercent = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.indicatorType);
        buf.writeInt(this.damagePercent);
    }

    public static class Handler
    implements IMessageHandler<AddHitS2CPacket, IMessage> {
        public IMessage onMessage(AddHitS2CPacket message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(AddHitS2CPacket message, MessageContext ctx) {
            ClientLatestHits.add(message.x, message.y, message.z, message.indicatorType, message.damagePercent);
        }
    }
}

