/*
 * Decompiled with CFR 0.152.
 */
package com.rosymaple.hitindication.event;

import com.rosymaple.hitindication.capability.latesthits.Indicator;
import com.rosymaple.hitindication.capability.latesthits.LatestHitsProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hitindication")
public class HitEvents {
    @SubscribeEvent
    public static void onAttack(LivingDamageEvent event) {
        if (!(event.getEntityLiving() instanceof ServerPlayerEntity) || !(event.getSource().func_76346_g() instanceof LivingEntity) || event.getSource().func_76364_f() instanceof PotionEntity) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
        LivingEntity source = (LivingEntity)event.getSource().func_76346_g();
        int damagePercent = (int)Math.floor(event.getAmount() / player.func_110138_aP() * 100.0f);
        player.getCapability(LatestHitsProvider.LATEST_HITS, null).ifPresent(hits -> hits.addHit(player, source, Indicator.RED, damagePercent, false));
    }

    @SubscribeEvent
    public static void onBlock(LivingAttackEvent event) {
        if (!(event.getEntityLiving() instanceof ServerPlayerEntity) || !(event.getSource().func_76346_g() instanceof LivingEntity) || event.getSource().func_76364_f() instanceof PotionEntity) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
        LivingEntity source = (LivingEntity)event.getSource().func_76346_g();
        player.getCapability(LatestHitsProvider.LATEST_HITS, null).ifPresent(hits -> {
            boolean playerIsBlocking = HitEvents.canBlockDamageSource(player, event.getSource());
            boolean shieldAboutToBreak = source.func_184614_ca().func_77973_b().canDisableShield(source.func_184614_ca(), player.func_184607_cu(), (LivingEntity)player, source);
            if (playerIsBlocking) {
                hits.addHit(player, source, Indicator.BLUE, shieldAboutToBreak ? 125 : 0, false);
            }
        });
    }

    @SubscribeEvent
    public static void onPotion(ProjectileImpactEvent.Throwable event) {
        if (!(event.getThrowable().func_234616_v_() instanceof LivingEntity && event.getThrowable().func_234616_v_().func_130014_f_() instanceof ServerWorld && event.getThrowable() instanceof PotionEntity)) {
            return;
        }
        AxisAlignedBB axisalignedbb = event.getThrowable().func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List list = event.getThrowable().field_70170_p.func_217357_a(ServerPlayerEntity.class, axisalignedbb);
        LivingEntity source = (LivingEntity)event.getThrowable().func_234616_v_();
        PotionEntity potion = (PotionEntity)event.getThrowable();
        boolean hasNegativeEffects = PotionUtils.func_185189_a((ItemStack)potion.func_184543_l()).stream().anyMatch(x -> !x.func_188419_a().func_188408_i());
        boolean damagingPotion = PotionUtils.func_185189_a((ItemStack)potion.func_184543_l()).stream().anyMatch(x -> x.func_188419_a() == Effects.field_76436_u || x.func_188419_a() == Effects.field_76433_i || x.func_188419_a() == Effects.field_82731_v);
        Optional<EffectInstance> instantDamage = PotionUtils.func_185189_a((ItemStack)potion.func_184543_l()).stream().filter(x -> x.func_188419_a() == Effects.field_76433_i).findFirst();
        for (ServerPlayerEntity player : list) {
            if (!player.func_184603_cC()) continue;
            player.getCapability(LatestHitsProvider.LATEST_HITS, null).ifPresent(hits -> {
                int damagePercent = 0;
                if (damagingPotion || hasNegativeEffects) {
                    if (instantDamage.isPresent()) {
                        damagePercent = (int)Math.floor(HitEvents.applyPotionDamageCalculations(player, DamageSource.field_76376_m, 3 * (2 << ((EffectInstance)instantDamage.get()).func_76458_c())) / player.func_110138_aP() * 100.0f);
                    }
                    hits.addHit(player, source, Indicator.RED, damagePercent, hasNegativeEffects);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (!(event.player instanceof ServerPlayerEntity) || event.phase == TickEvent.Phase.END) {
            return;
        }
        event.player.getCapability(LatestHitsProvider.LATEST_HITS, null).ifPresent(hits -> hits.tick((ServerPlayerEntity)event.player));
    }

    private static boolean canBlockDamageSource(ServerPlayerEntity entity, DamageSource damageSourceIn) {
        Vector3d vec3d;
        if (!damageSourceIn.func_76363_c() && entity.func_184585_cz() && (vec3d = damageSourceIn.func_188404_v()) != null) {
            Vector3d vec3d1 = entity.func_70676_i(1.0f);
            Vector3d vec3d2 = vec3d.func_72444_a(new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_())).func_72432_b();
            vec3d2 = new Vector3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private static float applyPotionDamageCalculations(ServerPlayerEntity player, DamageSource source, float damage) {
        if (source.func_151517_h()) {
            return damage;
        }
        if (player.func_70644_a(Effects.field_76429_m) && source != DamageSource.field_76380_i) {
            int i = (player.func_70660_b(Effects.field_76429_m).func_76458_c() + 1) * 5;
            int j = 25 - i;
            float f = damage * (float)j;
            damage = f / 25.0f;
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        int k = EnchantmentHelper.func_77508_a((Iterable)player.func_184193_aE(), (DamageSource)source);
        if (k > 0) {
            damage = CombatRules.func_188401_b((float)damage, (float)k);
        }
        return damage;
    }
}

