/*
 * Decompiled with CFR 0.152.
 */
package com.rosymaple.hitindication.event;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.rosymaple.hitindication.capability.latesthits.ClientLatestHits;
import com.rosymaple.hitindication.capability.latesthits.Hit;
import com.rosymaple.hitindication.capability.latesthits.Indicator;
import com.rosymaple.hitindication.config.HitIndicatorClientConfigs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="hitindication", value={Dist.CLIENT})
public class RenderEvents {
    private static final ResourceLocation INDICATOR_RED = new ResourceLocation("hitindication", "textures/hit/indicator_red.png");
    private static final ResourceLocation INDICATOR_BLUE = new ResourceLocation("hitindication", "textures/hit/indicator_blue.png");
    private static final int textureWidth = 42;
    private static final int textureHeight = 13;

    @SubscribeEvent
    public static void onRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        TextureManager textureManager = mc.func_110434_K();
        int screenMiddleX = event.getWindow().func_198107_o() / 2;
        int screenMiddleY = event.getWindow().func_198087_p() / 2;
        Vector2f lookVec = RenderEvents.getLookVec(mc.field_71439_g);
        Vector2f playerPos = new Vector2f((float)mc.field_71439_g.func_226277_ct_(), (float)mc.field_71439_g.func_226281_cx_());
        for (Hit hit : ClientLatestHits.latestHits) {
            RenderEvents.drawIndicator(event.getMatrixStack(), hit, textureManager, screenMiddleX, screenMiddleY, playerPos, lookVec);
        }
    }

    private static void drawIndicator(MatrixStack stack, Hit hit, TextureManager textureManager, int screenMiddleX, int screenMiddleY, Vector2f playerPos, Vector2f lookVec) {
        Vector3d sourceVec3d = hit.getLocation();
        Vector2f diff = new Vector2f((float)(sourceVec3d.field_72450_a - (double)playerPos.field_189982_i), (float)(sourceVec3d.field_72449_c - (double)playerPos.field_189983_j));
        double angleBetween = RenderEvents.angleBetween(lookVec, diff);
        float opacity = hit.getLifeTime() >= 25 ? (float)((Integer)HitIndicatorClientConfigs.IndicatorOpacity.get()).intValue() : (float)((Integer)HitIndicatorClientConfigs.IndicatorOpacity.get() * hit.getLifeTime()) / 25.0f;
        opacity /= 100.0f;
        float defaultScale = 1.0f + (float)((Integer)HitIndicatorClientConfigs.IndicatorDefaultScale.get()).intValue() / 100.0f;
        int scaledTextureWidth = (int)Math.floor(42.0f * defaultScale);
        int scaledTextureHeight = (int)Math.floor(13.0f * defaultScale);
        if (((Boolean)HitIndicatorClientConfigs.SizeDependsOnDamage.get()).booleanValue()) {
            float scale = MathHelper.func_76131_a((float)(hit.getDamagePercent() > 30 ? 1.0f + (float)hit.getDamagePercent() / 125.0f : 1.0f), (float)0.0f, (float)3.0f);
            scaledTextureWidth = (int)Math.floor((float)scaledTextureWidth * scale);
            scaledTextureHeight = (int)Math.floor((float)scaledTextureHeight * scale);
        }
        RenderEvents.bindIndicatorTexture(textureManager, hit.getIndicator());
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        GL11.glTranslatef((float)screenMiddleX, (float)screenMiddleY, (float)0.0f);
        GL11.glRotatef((float)((float)angleBetween), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-screenMiddleX), (float)(-screenMiddleY), (float)0.0f);
        AbstractGui.func_238463_a_((MatrixStack)stack, (int)(screenMiddleX - scaledTextureWidth / 2), (int)(screenMiddleY - scaledTextureHeight / 2 - 30), (float)0.0f, (float)0.0f, (int)scaledTextureWidth, (int)scaledTextureHeight, (int)scaledTextureWidth, (int)scaledTextureHeight);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private static void bindIndicatorTexture(TextureManager textureManager, Indicator type) {
        switch (type) {
            case BLUE: {
                textureManager.func_110577_a(INDICATOR_BLUE);
                break;
            }
            default: {
                textureManager.func_110577_a(INDICATOR_RED);
            }
        }
    }

    private static double angleBetween(Vector2f first, Vector2f second) {
        double dot = first.field_189982_i * second.field_189982_i + first.field_189983_j * second.field_189983_j;
        double cross = first.field_189982_i * second.field_189983_j - second.field_189982_i * first.field_189983_j;
        double res = Math.atan2(cross, dot) * 180.0 / Math.PI;
        return res;
    }

    private static Vector2f getLookVec(ClientPlayerEntity player) {
        return new Vector2f((float)(-Math.sin((double)(-player.field_70177_z) * Math.PI / 180.0 - Math.PI)), (float)(-Math.cos((double)(-player.field_70177_z) * Math.PI / 180.0 - Math.PI)));
    }
}

