/*
 * Decompiled with CFR 0.152.
 */
package com.rosymaple.hitindication.networking;

import com.rosymaple.hitindication.capability.latesthits.ClientLatestHits;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraftforge.fml.network.NetworkEvent;

public class AddHitS2CPacket {
    double x;
    double y;
    double z;
    int indicatorType;
    int damagePercent;
    boolean hasNegativeEffects;

    public AddHitS2CPacket(double x, double y, double z, int indicatorType, int damagePercent, boolean hasNegativeEffects) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.indicatorType = indicatorType;
        this.damagePercent = damagePercent;
        this.hasNegativeEffects = hasNegativeEffects;
    }

    public AddHitS2CPacket(ByteBuf buf) {
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.indicatorType = buf.readInt();
        this.damagePercent = buf.readInt();
        this.hasNegativeEffects = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeInt(this.indicatorType);
        buf.writeInt(this.damagePercent);
        buf.writeBoolean(this.hasNegativeEffects);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientLatestHits.add(this.x, this.y, this.z, this.indicatorType, this.damagePercent, this.hasNegativeEffects));
        return true;
    }
}

