/*
 * Decompiled with CFR 0.152.
 */
package com.rosymaple.hitindication.event;

import com.rosymaple.hitindication.capability.latesthits.Indicator;
import com.rosymaple.hitindication.capability.latesthits.LatestHitsProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hitindication")
public class HitEvents {
    @SubscribeEvent
    public static void onAttack(LivingDamageEvent event) {
        if (!(event.getEntityLiving() instanceof ServerPlayer) || !(event.getSource().m_7640_() instanceof LivingEntity) || event.getSource().m_7639_() instanceof ThrownPotion) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntityLiving();
        LivingEntity source = (LivingEntity)event.getSource().m_7640_();
        int damagePercent = (int)Math.floor(event.getAmount() / player.m_21233_() * 100.0f);
        player.getCapability(LatestHitsProvider.LATEST_HITS, null).ifPresent(hits -> hits.addHit(player, source, Indicator.RED, damagePercent, false));
    }

    @SubscribeEvent
    public static void onBlock(LivingAttackEvent event) {
        if (!(event.getEntityLiving() instanceof ServerPlayer) || !(event.getSource().m_7640_() instanceof LivingEntity) || event.getSource().m_7639_() instanceof ThrownPotion) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntityLiving();
        LivingEntity source = (LivingEntity)event.getSource().m_7640_();
        player.getCapability(LatestHitsProvider.LATEST_HITS, null).ifPresent(hits -> {
            boolean playerIsBlocking = HitEvents.canBlockDamageSource(player, event.getSource());
            boolean shieldAboutToBreak = source.m_21205_().m_41720_().canDisableShield(source.m_21205_(), player.m_21205_(), (LivingEntity)player, source);
            if (playerIsBlocking) {
                hits.addHit(player, source, Indicator.BLUE, shieldAboutToBreak ? 125 : 0, false);
            }
        });
    }

    @SubscribeEvent
    public static void onPotion(ProjectileImpactEvent event) {
        if (!(event.getProjectile() instanceof ThrowableProjectile && event.getProjectile().m_37282_() instanceof LivingEntity && event.getProjectile().m_37282_().m_183503_() instanceof ServerLevel && event.getProjectile() instanceof ThrownPotion)) {
            return;
        }
        AABB axisalignedbb = event.getProjectile().m_142469_().m_82377_(4.0, 2.0, 4.0);
        List list = event.getProjectile().f_19853_.m_45976_(ServerPlayer.class, axisalignedbb);
        LivingEntity source = (LivingEntity)event.getProjectile().m_37282_();
        ThrownPotion potion = (ThrownPotion)event.getProjectile();
        boolean hasNegativeEffects = PotionUtils.m_43547_((ItemStack)potion.m_7846_()).stream().anyMatch(x -> !x.m_19544_().m_19486_());
        boolean damagingPotion = PotionUtils.m_43547_((ItemStack)potion.m_7846_()).stream().anyMatch(x -> x.m_19544_() == MobEffects.f_19614_ || x.m_19544_() == MobEffects.f_19602_ || x.m_19544_() == MobEffects.f_19615_);
        Optional<MobEffectInstance> instantDamage = PotionUtils.m_43547_((ItemStack)potion.m_7846_()).stream().filter(x -> x.m_19544_() == MobEffects.f_19602_).findFirst();
        for (ServerPlayer player : list) {
            if (!player.m_5801_()) continue;
            player.getCapability(LatestHitsProvider.LATEST_HITS, null).ifPresent(hits -> {
                int damagePercent = 0;
                if (damagingPotion || hasNegativeEffects) {
                    if (instantDamage.isPresent()) {
                        damagePercent = (int)Math.floor(HitEvents.applyPotionDamageCalculations(player, DamageSource.f_19319_, 3 * (2 << ((MobEffectInstance)instantDamage.get()).m_19564_())) / player.m_21233_() * 100.0f);
                    }
                    hits.addHit(player, source, Indicator.RED, damagePercent, hasNegativeEffects);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (!(event.player instanceof ServerPlayer) || event.phase == TickEvent.Phase.END) {
            return;
        }
        event.player.getCapability(LatestHitsProvider.LATEST_HITS, null).ifPresent(hits -> hits.tick((ServerPlayer)event.player));
    }

    private static boolean canBlockDamageSource(ServerPlayer player, DamageSource pDamageSource) {
        Vec3 vec32;
        AbstractArrow abstractarrow;
        Entity entity = pDamageSource.m_7640_();
        boolean flag = false;
        if (entity instanceof AbstractArrow && (abstractarrow = (AbstractArrow)entity).m_36796_() > 0) {
            flag = true;
        }
        if (!pDamageSource.m_19376_() && player.m_21254_() && !flag && (vec32 = pDamageSource.m_7270_()) != null) {
            Vec3 vec3 = player.m_20252_(1.0f);
            Vec3 vec31 = vec32.m_82505_(player.m_20182_()).m_82541_();
            vec31 = new Vec3(vec31.f_82479_, 0.0, vec31.f_82481_);
            if (vec31.m_82526_(vec3) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private static float applyPotionDamageCalculations(ServerPlayer player, DamageSource pSource, float pDamage) {
        int i;
        int j;
        float f;
        float f1;
        float f2;
        if (pSource.m_19379_()) {
            return pDamage;
        }
        if (player.m_21023_(MobEffects.f_19606_) && pSource != DamageSource.f_19317_ && (f2 = (f1 = pDamage) - (pDamage = Math.max((f = pDamage * (float)(j = 25 - (i = (player.m_21124_(MobEffects.f_19606_).m_19564_() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f2 < 3.4028235E37f) {
            if (player instanceof ServerPlayer) {
                player.m_6278_(Stats.f_12988_.m_12902_((Object)Stats.f_12934_), Math.round(f2 * 10.0f));
            } else if (pSource.m_7639_() instanceof ServerPlayer) {
                ((ServerPlayer)pSource.m_7639_()).m_6278_(Stats.f_12988_.m_12902_((Object)Stats.f_12930_), Math.round(f2 * 10.0f));
            }
        }
        if (pDamage <= 0.0f) {
            return 0.0f;
        }
        int k = EnchantmentHelper.m_44856_((Iterable)player.m_6168_(), (DamageSource)pSource);
        if (k > 0) {
            pDamage = CombatRules.m_19269_((float)pDamage, (float)k);
        }
        return pDamage;
    }
}

